/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.visitors;

import io.apicurio.datamodels.models.visitors.TraversalContext;
import io.apicurio.datamodels.models.visitors.TraversalStep;
import io.apicurio.datamodels.models.visitors.TraversalStepType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class TraversalContextImpl
implements TraversalContext {
    private final Stack<TraversalStep> stack = new Stack();

    public void pushProperty(String propertyName) {
        this.stack.push(TraversalStep.fromNodeProperty(propertyName));
    }

    public void pushListIndex(int index) {
        this.stack.push(TraversalStep.fromListIndex(index));
    }

    public void pushMapIndex(String key) {
        this.stack.push(TraversalStep.fromMapIndex(key));
    }

    public void pop() {
        this.stack.pop();
    }

    public TraversalStep peek() {
        return this.stack.peek();
    }

    @Override
    public TraversalStep getMostRecentStep() {
        return this.stack.peek();
    }

    @Override
    public List<TraversalStep> getAllSteps() {
        TraversalStep[] steps = this.stack.toArray(new TraversalStep[this.stack.size()]);
        return Collections.unmodifiableList(Arrays.asList(steps));
    }

    @Override
    public String getMostRecentPropertyStep() {
        for (int idx = this.stack.size() - 1; idx >= 0; --idx) {
            TraversalStep step = (TraversalStep)this.stack.get(idx);
            if (step.getType() != TraversalStepType.property) continue;
            return (String)step.getValue();
        }
        return null;
    }

    @Override
    public boolean containsStep(TraversalStepType type, Object value) {
        for (TraversalStep step : this.stack) {
            if (step.getType() != type || !value.equals(step.getValue())) continue;
            return true;
        }
        return false;
    }
}

