/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.paths;

public class NodePathSegment {
    private final String value;
    private final boolean index;

    public NodePathSegment(String value, boolean index) {
        this.value = value;
        this.index = index;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isIndex() {
        return this.index;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean escaped) {
        String _value;
        StringBuilder builder = new StringBuilder();
        String string = escaped ? NodePathSegment.escapePathSegmentValue(this.value, !this.isIndex()) : (_value = this.value);
        if (this.isIndex()) {
            builder.append('[');
            builder.append(_value);
            builder.append(']');
        } else {
            builder.append('/');
            builder.append(_value);
        }
        return builder.toString();
    }

    public static NodePathSegment parse(String segment) {
        if (segment == null) {
            return new NodePathSegment(null, false);
        }
        boolean isIndex = false;
        if (segment.indexOf("[") == 0 && segment.indexOf("]") == segment.length() - 1) {
            segment = segment.substring(1, segment.length() - 1);
            isIndex = true;
        }
        segment = NodePathSegment.unescapePathSegmentValue(segment);
        return new NodePathSegment(segment, isIndex);
    }

    private static String escapePathSegmentValue(String rawValue, boolean escapeSlash) {
        String res = rawValue.replace("~", "~0");
        if (escapeSlash) {
            res = res.replace("/", "~1");
        }
        res = res.replace("[", "~2");
        res = res.replace("]", "~3");
        return res;
    }

    private static String unescapePathSegmentValue(String escapedValue) {
        String res = escapedValue.replace("~3", "]");
        res = res.replace("~2", "[");
        res = res.replace("~1", "/");
        res = res.replace("~0", "~");
        return res;
    }
}

