/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;

@RegisterForReflection
public enum ReferenceType {
    OUTBOUND("OUTBOUND"),
    INBOUND("INBOUND");

    private final String value;
    private static final Map<String, ReferenceType> CONSTANTS;

    private ReferenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ReferenceType fromValue(String value) {
        ReferenceType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ReferenceType>();
        for (ReferenceType c : ReferenceType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

