/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.BasicAuth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractRegistryMojo
extends AbstractMojo {
    @Parameter(required=true, property="registry.url")
    String registryUrl;
    @Parameter(property="auth.server.url")
    String authServerUrl;
    @Parameter(property="client.id")
    String clientId;
    @Parameter(property="client.secret")
    String clientSecret;
    @Parameter(property="client.scope")
    String clientScope;
    @Parameter(property="username")
    String username;
    @Parameter(property="password")
    String password;
    private RegistryClient client;
    private ApicurioHttpClient httpClient;

    protected RegistryClient getClient() {
        if (this.client == null) {
            if (this.authServerUrl != null && this.clientId != null && this.clientSecret != null) {
                this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
                OidcAuth auth = new OidcAuth(this.httpClient, this.clientId, this.clientSecret, null, this.clientScope);
                this.client = RegistryClientFactory.create((String)this.registryUrl, Collections.emptyMap(), (Auth)auth);
            } else if (this.username != null && this.password != null) {
                BasicAuth auth = new BasicAuth(this.username, this.password);
                this.client = RegistryClientFactory.create((String)this.registryUrl, Collections.emptyMap(), (Auth)auth);
            } else {
                this.client = RegistryClientFactory.create((String)this.registryUrl);
            }
        }
        return this.client;
    }

    public void setClient(RegistryClient client) {
        this.client = client;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeInternal();
        this.closeClients();
    }

    private void closeClients() {
        try {
            if (this.client != null) {
                this.client.close();
            }
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    protected String getContentTypeByExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String[] temp = fileName.split("[.]");
        String extension = temp[temp.length - 1];
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "avro": 
            case "avsc": 
            case "json": {
                return "application/json";
            }
            case "yml": 
            case "yaml": {
                return "application/x-yaml";
            }
            case "graphql": {
                return "application/graphql";
            }
            case "proto": {
                return "application/x-protobuf";
            }
            case "wsdl": 
            case "xsd": 
            case "xml": {
                return "application/xml";
            }
        }
        return null;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setClientScope(String clientScope) {
        this.clientScope = clientScope;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

