/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.maven.AbstractRegistryMojo;
import io.apicurio.registry.maven.DownloadArtifact;
import io.apicurio.registry.rest.client.RegistryClient;
import io.vertx.core.Vertx;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="download")
public class DownloadRegistryMojo
extends AbstractRegistryMojo {
    @Parameter(required=true)
    List<DownloadArtifact> artifacts;

    protected void validate() throws MojoExecutionException {
        if (this.artifacts == null || this.artifacts.isEmpty()) {
            this.getLog().warn((CharSequence)"No artifacts are configured for download.");
        } else {
            int idx = 0;
            int errorCount = 0;
            for (DownloadArtifact artifact : this.artifacts) {
                if (artifact.getGroupId() == null) {
                    this.getLog().error((CharSequence)String.format("GroupId is required when downloading an artifact.  Missing from artifacts[%d].", idx));
                    ++errorCount;
                }
                if (artifact.getArtifactId() == null) {
                    this.getLog().error((CharSequence)String.format("ArtifactId is required when downloading an artifact.  Missing from artifacts[%s].", idx));
                    ++errorCount;
                }
                if (artifact.getFile() == null) {
                    this.getLog().error((CharSequence)String.format("File is required when downloading an artifact.  Missing from artifacts[%s].", idx));
                    ++errorCount;
                } else if (artifact.getFile().exists() && (artifact.getOverwrite() == null || !artifact.getOverwrite().booleanValue())) {
                    this.getLog().error((CharSequence)String.format("File being written already exists.  Use <overwrite>true</overwrite> to replace the destination file: %s", artifact.getFile().getPath()));
                    ++errorCount;
                }
                ++idx;
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Invalid configuration of the Download Artifact(s) mojo. See the output log for details.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeInternal() throws MojoExecutionException, ExecutionException, InterruptedException {
        this.validate();
        Vertx vertx = this.createVertx();
        RegistryClient registryClient = this.createClient(vertx);
        try {
            int errorCount = 0;
            if (this.artifacts != null) {
                for (DownloadArtifact artifact : this.artifacts) {
                    errorCount += this.downloadArtifact(registryClient, artifact);
                }
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Errors while downloading artifacts ...");
            }
        }
        finally {
            vertx.close();
        }
    }

    private int downloadArtifact(RegistryClient registryClient, DownloadArtifact artifact) throws ExecutionException, InterruptedException {
        int errorCount = 0;
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        if (version == null) {
            version = "branch=latest";
        }
        boolean replaceExisting = artifact.getOverwrite() != null && artifact.getOverwrite() != false;
        this.getLog().info((CharSequence)String.format("Downloading artifact [%s] / [%s] (version %s).", groupId, artifactId, version));
        try (InputStream content = registryClient.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).content().get();){
            if (!artifact.getFile().getParentFile().exists()) {
                artifact.getFile().getParentFile().mkdirs();
            }
            if (replaceExisting) {
                Files.copy(content, artifact.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(content, artifact.getFile().toPath(), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            ++errorCount;
            this.getLog().error((CharSequence)String.format("Exception while downloading artifact [%s] / [%s]", groupId, artifactId), (Throwable)e);
        }
        this.getLog().info((CharSequence)String.format("Downloaded artifact [%s] / [%s] to %s.", groupId, artifactId, artifact.getFile()));
        if (artifact.getArtifactReferences() != null && !artifact.getArtifactReferences().isEmpty()) {
            for (DownloadArtifact reference : artifact.getArtifactReferences()) {
                errorCount += this.downloadArtifact(registryClient, reference);
            }
        }
        return errorCount;
    }

    public void setArtifacts(List<DownloadArtifact> artifacts) {
        this.artifacts = artifacts;
    }
}

