/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.refs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.refs.ExternalReference;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import io.apicurio.registry.content.refs.ReferenceFinder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaReferenceFinder
implements ReferenceFinder {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaReferenceFinder.class);

    public Set<ExternalReference> findExternalReferences(ContentHandle content) {
        try {
            JsonNode tree = mapper.readTree(content.content());
            HashSet<String> externalTypes = new HashSet<String>();
            JsonSchemaReferenceFinder.findExternalTypesIn(tree, externalTypes);
            return externalTypes.stream().map(type -> new JsonPointerExternalReference(type)).filter(ref -> ref.getResource() != null).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("Error finding external references in an Avro file.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static void findExternalTypesIn(JsonNode schema, Set<String> externalTypes) {
        if (schema.isObject()) {
            String ref;
            if (schema.has("$ref") && (ref = schema.get("$ref").asText(null)) != null) {
                externalTypes.add(ref);
            }
            Iterator fields = schema.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonSchemaReferenceFinder.findExternalTypesIn((JsonNode)field.getValue(), externalTypes);
            }
        }
    }
}

