/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.StringSchemaWrapper;
import java.util.Map;
import java.util.regex.Pattern;
import org.everit.json.schema.StringSchema;

public class StringSchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final StringSchema original;

    public StringSchemaDiffVisitor(DiffContext ctx, StringSchema original) {
        this.ctx = ctx;
        this.original = original;
    }

    @Override
    public void visitStringSchema(StringSchemaWrapper stringSchema) {
        this.ctx.log("Visiting " + stringSchema + " at " + stringSchema.getWrapped().getLocation());
        Map originalUnprocessed = this.original.getUnprocessedProperties();
        Map<String, Object> updatedUnprocessed = stringSchema.getUnprocessedProperties();
        DiffContext subCtx = this.ctx.sub("contentEncoding");
        DiffUtil.diffObject(subCtx, DiffUtil.getExceptionally(subCtx, () -> originalUnprocessed.get("contentEncoding")), DiffUtil.getExceptionally(subCtx, () -> updatedUnprocessed.get("contentEncoding")), DiffType.STRING_TYPE_CONTENT_ENCODING_ADDED, DiffType.STRING_TYPE_CONTENT_ENCODING_REMOVED, DiffType.STRING_TYPE_CONTENT_ENCODING_CHANGED);
        subCtx = this.ctx.sub("contentMediaType");
        DiffUtil.diffObject(subCtx, DiffUtil.getExceptionally(subCtx, () -> originalUnprocessed.get("contentMediaType")), DiffUtil.getExceptionally(subCtx, () -> updatedUnprocessed.get("contentMediaType")), DiffType.STRING_TYPE_CONTENT_MEDIA_TYPE_ADDED, DiffType.STRING_TYPE_CONTENT_MEDIA_TYPE_REMOVED, DiffType.STRING_TYPE_CONTENT_MEDIA_TYPE_CHANGED);
        super.visitStringSchema(stringSchema);
    }

    @Override
    public void visitMinLength(Integer minLength) {
        this.ctx.log("Visiting minLength: " + minLength);
        DiffUtil.diffInteger(this.ctx.sub("minLength"), this.original.getMinLength(), minLength, DiffType.STRING_TYPE_MIN_LENGTH_ADDED, DiffType.STRING_TYPE_MIN_LENGTH_REMOVED, DiffType.STRING_TYPE_MIN_LENGTH_INCREASED, DiffType.STRING_TYPE_MIN_LENGTH_DECREASED);
        super.visitMinLength(minLength);
    }

    @Override
    public void visitMaxLength(Integer maxLength) {
        this.ctx.log("Visiting maxLength " + maxLength);
        DiffUtil.diffInteger(this.ctx.sub("maxLength"), this.original.getMaxLength(), maxLength, DiffType.STRING_TYPE_MAX_LENGTH_ADDED, DiffType.STRING_TYPE_MAX_LENGTH_REMOVED, DiffType.STRING_TYPE_MAX_LENGTH_INCREASED, DiffType.STRING_TYPE_MAX_LENGTH_DECREASED);
        super.visitMaxLength(maxLength);
    }

    @Override
    public void visitPattern(Pattern pattern) {
        this.ctx.log("Visiting pattern " + pattern);
        DiffContext subCtx = this.ctx.sub("pattern");
        DiffUtil.diffObject(subCtx, DiffUtil.getExceptionally(subCtx, () -> this.original.getPattern().pattern()), pattern.pattern(), DiffType.STRING_TYPE_PATTERN_ADDED, DiffType.STRING_TYPE_PATTERN_REMOVED, DiffType.STRING_TYPE_PATTERN_CHANGED);
        super.visitPattern(pattern);
    }

    @Override
    public void visitFormat(String formatName) {
        this.ctx.log("Visiting formatValidator " + formatName);
        DiffContext subCtx = this.ctx.sub("format");
        DiffUtil.diffObjectDefault(subCtx, DiffUtil.getExceptionally(subCtx, () -> this.original.getFormatValidator().formatName()), formatName, "unnamed-format", DiffType.STRING_TYPE_FORMAT_ADDED, DiffType.STRING_TYPE_FORMAT_REMOVED, DiffType.STRING_TYPE_FORMAT_CHANGED);
        super.visitFormat(formatName);
    }
}

