/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.extract;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApicurioDataModelsContentExtractor
implements ContentExtractor {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public ExtractedMetaData extract(ContentHandle content) {
        try {
            Document openApi = Library.readDocumentFromJSONString((String)content.content());
            MetaDataVisitor viz = new MetaDataVisitor();
            Library.visitTree((Node)openApi, (Visitor)viz, (TraverserDirection)TraverserDirection.down);
            ExtractedMetaData metaData = null;
            if (viz.name != null || viz.description != null) {
                metaData = new ExtractedMetaData();
            }
            if (viz.name != null) {
                metaData.setName(viz.name);
            }
            if (viz.description != null) {
                metaData.setDescription(viz.description);
            }
            return metaData;
        }
        catch (Exception e) {
            this.log.warn("Error extracting metadata from Open/Async API: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static class MetaDataVisitor
    extends CombinedVisitorAdapter {
        String name;
        String description;

        private MetaDataVisitor() {
        }

        public void visitInfo(Info node) {
            this.name = node.getTitle();
            this.description = node.getDescription();
        }
    }
}

