/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.refs;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.refs.ExternalReference;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import io.apicurio.registry.content.refs.ReferenceFinder;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractDataModelsReferenceFinder
implements ReferenceFinder {
    public Set<ExternalReference> findExternalReferences(ContentHandle content) {
        Document doc = Library.readDocumentFromJSONString((String)content.content());
        RefFinderVisitor visitor = new RefFinderVisitor();
        Library.visitTree((Node)doc, (Visitor)visitor, (TraverserDirection)TraverserDirection.down);
        return visitor.allReferences.stream().map(ref -> new JsonPointerExternalReference(ref)).filter(ref -> ref.getResource() != null).collect(Collectors.toSet());
    }

    private static class RefFinderVisitor
    extends AllNodeVisitor {
        public Set<String> allReferences = new HashSet<String>();

        private RefFinderVisitor() {
        }

        protected void visitNode(Node node) {
            String ref;
            if (node instanceof Referenceable && (ref = ((Referenceable)node).get$ref()) != null && !ref.trim().isEmpty()) {
                this.allReferences.add(ref);
            }
        }

        public void visitMessage(AsyncApiMessage node) {
            JsonNode payload = node.getPayload();
            if (payload != null && payload.has("$ref") && !payload.get("$ref").isNull()) {
                String ref = payload.get("$ref").asText();
                this.allReferences.add(ref);
            }
            super.visitMessage(node);
        }
    }
}

