/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ApicurioDataModelContentValidator
implements ContentValidator {
    public void validate(ValidityLevel level, ContentHandle artifactContent, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        List problems;
        Document document = null;
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                document = Library.readDocumentFromJSONString((String)artifactContent.content());
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for " + this.getDataModelType() + " artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
        if (level == ValidityLevel.FULL && !(problems = Library.validate((Node)document, null)).isEmpty()) {
            Set causes = problems.stream().map(problem -> new RuleViolation(problem.message, problem.nodePath.toString())).collect(Collectors.toSet());
            throw new RuleViolationException("The " + this.getDataModelType() + " artifact is not semantically valid. " + problems.size() + " problems found.", RuleType.VALIDITY, level.name(), causes);
        }
    }

    public void validateReferences(ContentHandle artifactContent, List<ArtifactReference> references) throws RuleViolationException {
        Set mappedRefs = references.stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        Set<String> all$refs = this.getAll$refs(artifactContent);
        Set violations = all$refs.stream().filter(ref -> !mappedRefs.contains(ref)).map(missingRef -> new RuleViolation("Unmapped reference detected.", missingRef)).collect(Collectors.toSet());
        if (!violations.isEmpty()) {
            throw new RuleViolationException("Unmapped reference(s) detected.", RuleType.INTEGRITY, IntegrityLevel.ALL_REFS_MAPPED.name(), violations);
        }
    }

    private Set<String> getAll$refs(ContentHandle artifactContent) {
        try {
            RefFinder refFinder = new RefFinder();
            Document document = Library.readDocumentFromJSONString((String)artifactContent.content());
            Library.visitTree((Node)document, (Visitor)refFinder, (TraverserDirection)TraverserDirection.down);
            return refFinder.references;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    protected abstract String getDataModelType();

    private static class RefFinder
    extends AllNodeVisitor {
        Set<String> references = new HashSet<String>();

        private RefFinder() {
        }

        protected void visitNode(Node node) {
            String theRef;
            if (node instanceof Referenceable && (theRef = ((Referenceable)node).get$ref()) != null && !theRef.startsWith("#/")) {
                this.references.add(theRef);
            }
        }
    }
}

