/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.refs;

import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.refs.ExternalReference;
import io.apicurio.registry.content.refs.ReferenceFinder;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufReferenceFinder
implements ReferenceFinder {
    private static final Logger log = LoggerFactory.getLogger(ProtobufReferenceFinder.class);

    public Set<ExternalReference> findExternalReferences(ContentHandle content) {
        try {
            ProtoFileElement protoFileElement = ProtobufFile.toProtoFileElement((String)content.content());
            HashSet allImports = new HashSet();
            allImports.addAll(protoFileElement.getImports());
            allImports.addAll(protoFileElement.getPublicImports());
            return allImports.stream().map(imprt -> new ExternalReference(imprt)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("Error finding external references in a Protobuf file.", (Throwable)e);
            return Collections.emptySet();
        }
    }
}

