/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ws;

import io.appium.java_client.ws.CanHandleConnects;
import io.appium.java_client.ws.CanHandleDisconnects;
import io.appium.java_client.ws.CanHandleErrors;
import io.appium.java_client.ws.CanHandleMessages;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.WebSocket;

public class StringWebSocketClient
implements WebSocket.Listener,
CanHandleMessages<String>,
CanHandleErrors,
CanHandleConnects,
CanHandleDisconnects {
    private final List<Consumer<String>> messageHandlers = new CopyOnWriteArrayList<Consumer<String>>();
    private final List<Consumer<Throwable>> errorHandlers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> connectHandlers = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectHandlers = new CopyOnWriteArrayList<Runnable>();
    private volatile boolean isListening = false;
    private URI endpoint;

    private void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Nullable
    public URI getEndpoint() {
        return this.endpoint;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void connect(URI endpoint) {
        if (endpoint.equals(this.getEndpoint()) && this.isListening) {
            return;
        }
        ClientConfig clientConfig = ClientConfig.defaultConfig().readTimeout(Duration.ZERO).baseUri(endpoint);
        HttpClient client = HttpClient.Factory.createDefault().createClient(clientConfig);
        HttpRequest request = new HttpRequest(HttpMethod.GET, endpoint.toString());
        client.openSocket(request, (WebSocket.Listener)this);
        this.onOpen();
        this.setEndpoint(endpoint);
    }

    public void onOpen() {
        this.getConnectionHandlers().forEach(Runnable::run);
        this.isListening = true;
    }

    public void onClose(int code, String reason) {
        this.getDisconnectionHandlers().forEach(Runnable::run);
        this.isListening = false;
    }

    public void onError(Throwable t) {
        this.getErrorHandlers().forEach(x -> x.accept(t));
    }

    public void onText(CharSequence data) {
        String text = data.toString();
        this.getMessageHandlers().forEach(x -> x.accept(text));
    }

    @Override
    public List<Consumer<String>> getMessageHandlers() {
        return this.messageHandlers;
    }

    @Override
    public List<Consumer<Throwable>> getErrorHandlers() {
        return this.errorHandlers;
    }

    @Override
    public List<Runnable> getConnectionHandlers() {
        return this.connectHandlers;
    }

    @Override
    public List<Runnable> getDisconnectionHandlers() {
        return this.disconnectHandlers;
    }

    public void removeAllHandlers() {
        this.removeMessageHandlers();
        this.removeErrorHandlers();
        this.removeConnectionHandlers();
        this.removeDisconnectionHandlers();
    }
}

