/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumCommandInfo;
import io.appium.java_client.imagecomparison.BaseComparisonOptions;
import io.appium.java_client.imagecomparison.ComparisonMode;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import io.appium.java_client.screenrecording.BaseStopScreenRecordingOptions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.http.HttpMethod;

public class MobileCommand {
    @Deprecated
    protected static final String RESET = "reset";
    @Deprecated
    protected static final String GET_STRINGS = "getStrings";
    @Deprecated
    public static final String SET_VALUE = "setValue";
    @Deprecated
    protected static final String PULL_FILE = "pullFile";
    @Deprecated
    protected static final String PULL_FOLDER = "pullFolder";
    @Deprecated
    public static final String RUN_APP_IN_BACKGROUND = "runAppInBackground";
    @Deprecated
    protected static final String PERFORM_TOUCH_ACTION = "performTouchAction";
    @Deprecated
    protected static final String PERFORM_MULTI_TOUCH = "performMultiTouch";
    @Deprecated
    public static final String LAUNCH_APP = "launchApp";
    @Deprecated
    public static final String CLOSE_APP = "closeApp";
    @Deprecated
    protected static final String GET_DEVICE_TIME = "getDeviceTime";
    @Deprecated
    protected static final String GET_SESSION = "getSession";
    protected static final String LOG_EVENT = "logCustomEvent";
    protected static final String GET_EVENTS = "getLogEvents";
    @Deprecated
    protected static final String IS_APP_INSTALLED = "isAppInstalled";
    @Deprecated
    protected static final String INSTALL_APP;
    @Deprecated
    protected static final String ACTIVATE_APP;
    @Deprecated
    protected static final String QUERY_APP_STATE;
    @Deprecated
    protected static final String TERMINATE_APP;
    @Deprecated
    protected static final String REMOVE_APP;
    @Deprecated
    public static final String GET_CLIPBOARD;
    @Deprecated
    public static final String SET_CLIPBOARD;
    @Deprecated
    protected static final String GET_PERFORMANCE_DATA;
    @Deprecated
    protected static final String GET_SUPPORTED_PERFORMANCE_DATA_TYPES;
    @Deprecated
    public static final String START_RECORDING_SCREEN;
    @Deprecated
    public static final String STOP_RECORDING_SCREEN;
    @Deprecated
    protected static final String HIDE_KEYBOARD;
    @Deprecated
    protected static final String LOCK;
    @Deprecated
    protected static final String SHAKE;
    @Deprecated
    protected static final String TOUCH_ID;
    @Deprecated
    protected static final String TOUCH_ID_ENROLLMENT;
    @Deprecated
    public static final String CURRENT_ACTIVITY;
    @Deprecated
    protected static final String END_TEST_COVERAGE;
    @Deprecated
    protected static final String GET_DISPLAY_DENSITY;
    @Deprecated
    protected static final String GET_NETWORK_CONNECTION;
    @Deprecated
    protected static final String GET_SYSTEM_BARS;
    @Deprecated
    protected static final String IS_KEYBOARD_SHOWN;
    @Deprecated
    protected static final String IS_LOCKED;
    @Deprecated
    public static final String LONG_PRESS_KEY_CODE;
    @Deprecated
    protected static final String FINGER_PRINT;
    @Deprecated
    protected static final String OPEN_NOTIFICATIONS;
    @Deprecated
    public static final String PRESS_KEY_CODE;
    @Deprecated
    protected static final String PUSH_FILE;
    @Deprecated
    protected static final String SET_NETWORK_CONNECTION;
    @Deprecated
    protected static final String START_ACTIVITY;
    @Deprecated
    protected static final String TOGGLE_LOCATION_SERVICES;
    @Deprecated
    protected static final String UNLOCK;
    @Deprecated
    public static final String REPLACE_VALUE;
    protected static final String GET_SETTINGS;
    @Deprecated
    protected static final String SET_SETTINGS;
    @Deprecated
    public static final String GET_CURRENT_PACKAGE;
    @Deprecated
    public static final String SEND_SMS;
    @Deprecated
    public static final String GSM_CALL;
    @Deprecated
    public static final String GSM_SIGNAL;
    @Deprecated
    public static final String GSM_VOICE;
    @Deprecated
    public static final String NETWORK_SPEED;
    @Deprecated
    public static final String POWER_CAPACITY;
    @Deprecated
    public static final String POWER_AC_STATE;
    @Deprecated
    protected static final String TOGGLE_WIFI;
    @Deprecated
    protected static final String TOGGLE_AIRPLANE_MODE;
    @Deprecated
    protected static final String TOGGLE_DATA;
    protected static final String COMPARE_IMAGES;
    protected static final String EXECUTE_DRIVER_SCRIPT;
    @Deprecated
    protected static final String GET_ALLSESSION;
    protected static final String EXECUTE_GOOGLE_CDP_COMMAND;
    public static final String GET_SCREEN_ORIENTATION = "getScreenOrientation";
    public static final String SET_SCREEN_ORIENTATION = "setScreenOrientation";
    public static final String GET_SCREEN_ROTATION = "getScreenRotation";
    public static final String SET_SCREEN_ROTATION = "setScreenRotation";
    public static final String GET_CONTEXT_HANDLES = "getContextHandles";
    public static final String GET_CURRENT_CONTEXT_HANDLE = "getCurrentContextHandle";
    public static final String SWITCH_TO_CONTEXT = "switchToContext";
    public static final String GET_LOCATION = "getLocation";
    public static final String SET_LOCATION = "setLocation";
    public static final Map<String, CommandInfo> commandRepository;

    public static AppiumCommandInfo getC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.GET);
    }

    public static AppiumCommandInfo postC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.POST);
    }

    public static AppiumCommandInfo deleteC(String url) {
        return new AppiumCommandInfo(url, HttpMethod.DELETE);
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> hideKeyboardCommand(String keyName) {
        return Map.entry(HIDE_KEYBOARD, Map.of("keyName", keyName));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> hideKeyboardCommand(String strategy, String keyName) {
        return Map.entry(HIDE_KEYBOARD, Map.of("strategy", strategy, "key", keyName));
    }

    @Deprecated
    public static ImmutableMap<String, Object> prepareArguments(String param, Object value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)param, value);
        return builder.build();
    }

    @Deprecated
    public static ImmutableMap<String, Object> prepareArguments(String[] params, Object[] values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < params.length; ++i) {
            if (Strings.isNullOrEmpty((String)params[i]) || values[i] == null) continue;
            builder.put((Object)params[i], values[i]);
        }
        return builder.build();
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key) {
        return Map.entry(PRESS_KEY_CODE, Map.of("keycode", key));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> pressKeyCodeCommand(int key, Integer metastate) {
        return Map.entry(PRESS_KEY_CODE, Map.of("keycode", key, "metastate", metastate));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key) {
        return Map.entry(LONG_PRESS_KEY_CODE, Map.of("keycode", key));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> longPressKeyCodeCommand(int key, Integer metastate) {
        return Map.entry(LONG_PRESS_KEY_CODE, Map.of("keycode", key, "metastate", metastate));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> lockDeviceCommand(Duration duration) {
        return Map.entry(LOCK, Map.of("seconds", duration.getSeconds()));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> unlockDeviceCommand() {
        return Map.entry(UNLOCK, Map.of());
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> getIsDeviceLockedCommand() {
        return Map.entry(IS_LOCKED, Map.of());
    }

    public static Map.Entry<String, Map<String, ?>> getSettingsCommand() {
        return Map.entry(GET_SETTINGS, Map.of());
    }

    public static Map.Entry<String, Map<String, ?>> setSettingsCommand(String setting, Object value) {
        return MobileCommand.setSettingsCommand(Map.of(setting, value));
    }

    public static Map.Entry<String, Map<String, ?>> setSettingsCommand(Map<String, Object> settings) {
        return Map.entry(SET_SETTINGS, Map.of("settings", settings));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> pushFileCommand(String remotePath, byte[] base64Data) {
        return Map.entry(PUSH_FILE, Map.of("path", remotePath, "data", new String(base64Data, StandardCharsets.UTF_8)));
    }

    public static Map.Entry<String, Map<String, ?>> startRecordingScreenCommand(BaseStartScreenRecordingOptions opts) {
        return Map.entry(START_RECORDING_SCREEN, Map.of("options", opts.build()));
    }

    public static Map.Entry<String, Map<String, ?>> stopRecordingScreenCommand(BaseStopScreenRecordingOptions opts) {
        return Map.entry(STOP_RECORDING_SCREEN, Map.of("options", opts.build()));
    }

    public static Map.Entry<String, Map<String, ?>> compareImagesCommand(ComparisonMode mode, byte[] img1Data, byte[] img2Data, @Nullable BaseComparisonOptions options) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("mode", mode.toString());
        args.put("firstImage", new String(img1Data, StandardCharsets.UTF_8));
        args.put("secondImage", new String(img2Data, StandardCharsets.UTF_8));
        Optional.ofNullable(options).ifPresent(opts -> args.put("options", (String)((Object)options.build())));
        return Map.entry(COMPARE_IMAGES, Collections.unmodifiableMap(args));
    }

    @Deprecated
    public static Map.Entry<String, Map<String, ?>> isKeyboardShownCommand() {
        return Map.entry(IS_KEYBOARD_SHOWN, Map.of());
    }

    static {
        QUERY_APP_STATE = "queryAppState";
        TERMINATE_APP = "terminateApp";
        ACTIVATE_APP = "activateApp";
        REMOVE_APP = "removeApp";
        INSTALL_APP = "installApp";
        SET_CLIPBOARD = "setClipboard";
        GET_CLIPBOARD = "getClipboard";
        GET_PERFORMANCE_DATA = "getPerformanceData";
        GET_SUPPORTED_PERFORMANCE_DATA_TYPES = "getSuppportedPerformanceDataTypes";
        START_RECORDING_SCREEN = "startRecordingScreen";
        STOP_RECORDING_SCREEN = "stopRecordingScreen";
        HIDE_KEYBOARD = "hideKeyboard";
        LOCK = "lock";
        SHAKE = "shake";
        TOUCH_ID = "touchId";
        TOUCH_ID_ENROLLMENT = "toggleEnrollTouchId";
        CURRENT_ACTIVITY = "currentActivity";
        END_TEST_COVERAGE = "endTestCoverage";
        GET_DISPLAY_DENSITY = "getDisplayDensity";
        GET_NETWORK_CONNECTION = "getNetworkConnection";
        GET_SYSTEM_BARS = "getSystemBars";
        IS_KEYBOARD_SHOWN = "isKeyboardShown";
        IS_LOCKED = "isLocked";
        LONG_PRESS_KEY_CODE = "longPressKeyCode";
        FINGER_PRINT = "fingerPrint";
        OPEN_NOTIFICATIONS = "openNotifications";
        PRESS_KEY_CODE = "pressKeyCode";
        PUSH_FILE = "pushFile";
        SET_NETWORK_CONNECTION = "setNetworkConnection";
        START_ACTIVITY = "startActivity";
        TOGGLE_LOCATION_SERVICES = "toggleLocationServices";
        UNLOCK = "unlock";
        REPLACE_VALUE = "replaceValue";
        GET_SETTINGS = "getSettings";
        SET_SETTINGS = "setSettings";
        GET_CURRENT_PACKAGE = "getCurrentPackage";
        SEND_SMS = "sendSMS";
        GSM_CALL = "gsmCall";
        GSM_SIGNAL = "gsmSignal";
        GSM_VOICE = "gsmVoice";
        NETWORK_SPEED = "networkSpeed";
        POWER_CAPACITY = "powerCapacity";
        POWER_AC_STATE = "powerAC";
        TOGGLE_WIFI = "toggleWiFi";
        TOGGLE_AIRPLANE_MODE = "toggleFlightMode";
        TOGGLE_DATA = "toggleData";
        COMPARE_IMAGES = "compareImages";
        EXECUTE_DRIVER_SCRIPT = "executeDriverScript";
        GET_ALLSESSION = "getAllSessions";
        EXECUTE_GOOGLE_CDP_COMMAND = "executeCdp";
        commandRepository = new HashMap<String, CommandInfo>();
        commandRepository.put(RESET, MobileCommand.postC("/session/:sessionId/appium/app/reset"));
        commandRepository.put(GET_STRINGS, MobileCommand.postC("/session/:sessionId/appium/app/strings"));
        commandRepository.put(SET_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/value"));
        commandRepository.put(PULL_FILE, MobileCommand.postC("/session/:sessionId/appium/device/pull_file"));
        commandRepository.put(PULL_FOLDER, MobileCommand.postC("/session/:sessionId/appium/device/pull_folder"));
        commandRepository.put(HIDE_KEYBOARD, MobileCommand.postC("/session/:sessionId/appium/device/hide_keyboard"));
        commandRepository.put(RUN_APP_IN_BACKGROUND, MobileCommand.postC("/session/:sessionId/appium/app/background"));
        commandRepository.put(PERFORM_TOUCH_ACTION, MobileCommand.postC("/session/:sessionId/touch/perform"));
        commandRepository.put(PERFORM_MULTI_TOUCH, MobileCommand.postC("/session/:sessionId/touch/multi/perform"));
        commandRepository.put(LAUNCH_APP, MobileCommand.postC("/session/:sessionId/appium/app/launch"));
        commandRepository.put(CLOSE_APP, MobileCommand.postC("/session/:sessionId/appium/app/close"));
        commandRepository.put(LOCK, MobileCommand.postC("/session/:sessionId/appium/device/lock"));
        commandRepository.put(GET_SETTINGS, MobileCommand.getC("/session/:sessionId/appium/settings"));
        commandRepository.put(SET_SETTINGS, MobileCommand.postC("/session/:sessionId/appium/settings"));
        commandRepository.put(GET_DEVICE_TIME, MobileCommand.getC("/session/:sessionId/appium/device/system_time"));
        commandRepository.put(GET_SESSION, MobileCommand.getC("/session/:sessionId/"));
        commandRepository.put(GET_SUPPORTED_PERFORMANCE_DATA_TYPES, MobileCommand.postC("/session/:sessionId/appium/performanceData/types"));
        commandRepository.put(GET_PERFORMANCE_DATA, MobileCommand.postC("/session/:sessionId/appium/getPerformanceData"));
        commandRepository.put(START_RECORDING_SCREEN, MobileCommand.postC("/session/:sessionId/appium/start_recording_screen"));
        commandRepository.put(STOP_RECORDING_SCREEN, MobileCommand.postC("/session/:sessionId/appium/stop_recording_screen"));
        commandRepository.put(GET_EVENTS, MobileCommand.postC("/session/:sessionId/appium/events"));
        commandRepository.put(LOG_EVENT, MobileCommand.postC("/session/:sessionId/appium/log_event"));
        commandRepository.put(IS_APP_INSTALLED, MobileCommand.postC("/session/:sessionId/appium/device/app_installed"));
        commandRepository.put(INSTALL_APP, MobileCommand.postC("/session/:sessionId/appium/device/install_app"));
        commandRepository.put(ACTIVATE_APP, MobileCommand.postC("/session/:sessionId/appium/device/activate_app"));
        commandRepository.put(REMOVE_APP, MobileCommand.postC("/session/:sessionId/appium/device/remove_app"));
        commandRepository.put(TERMINATE_APP, MobileCommand.postC("/session/:sessionId/appium/device/terminate_app"));
        commandRepository.put(QUERY_APP_STATE, MobileCommand.postC("/session/:sessionId/appium/device/app_state"));
        commandRepository.put(GET_CLIPBOARD, MobileCommand.postC("/session/:sessionId/appium/device/get_clipboard"));
        commandRepository.put(SET_CLIPBOARD, MobileCommand.postC("/session/:sessionId/appium/device/set_clipboard"));
        commandRepository.put(SHAKE, MobileCommand.postC("/session/:sessionId/appium/device/shake"));
        commandRepository.put(TOUCH_ID, MobileCommand.postC("/session/:sessionId/appium/simulator/touch_id"));
        commandRepository.put(TOUCH_ID_ENROLLMENT, MobileCommand.postC("/session/:sessionId/appium/simulator/toggle_touch_id_enrollment"));
        commandRepository.put(CURRENT_ACTIVITY, MobileCommand.getC("/session/:sessionId/appium/device/current_activity"));
        commandRepository.put(END_TEST_COVERAGE, MobileCommand.postC("/session/:sessionId/appium/app/end_test_coverage"));
        commandRepository.put(GET_DISPLAY_DENSITY, MobileCommand.getC("/session/:sessionId/appium/device/display_density"));
        commandRepository.put(GET_NETWORK_CONNECTION, MobileCommand.getC("/session/:sessionId/network_connection"));
        commandRepository.put(GET_SYSTEM_BARS, MobileCommand.getC("/session/:sessionId/appium/device/system_bars"));
        commandRepository.put(IS_KEYBOARD_SHOWN, MobileCommand.getC("/session/:sessionId/appium/device/is_keyboard_shown"));
        commandRepository.put(IS_LOCKED, MobileCommand.postC("/session/:sessionId/appium/device/is_locked"));
        commandRepository.put(LONG_PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/long_press_keycode"));
        commandRepository.put(FINGER_PRINT, MobileCommand.postC("/session/:sessionId/appium/device/finger_print"));
        commandRepository.put(OPEN_NOTIFICATIONS, MobileCommand.postC("/session/:sessionId/appium/device/open_notifications"));
        commandRepository.put(PRESS_KEY_CODE, MobileCommand.postC("/session/:sessionId/appium/device/press_keycode"));
        commandRepository.put(PUSH_FILE, MobileCommand.postC("/session/:sessionId/appium/device/push_file"));
        commandRepository.put(SET_NETWORK_CONNECTION, MobileCommand.postC("/session/:sessionId/network_connection"));
        commandRepository.put(START_ACTIVITY, MobileCommand.postC("/session/:sessionId/appium/device/start_activity"));
        commandRepository.put(TOGGLE_LOCATION_SERVICES, MobileCommand.postC("/session/:sessionId/appium/device/toggle_location_services"));
        commandRepository.put(UNLOCK, MobileCommand.postC("/session/:sessionId/appium/device/unlock"));
        commandRepository.put(REPLACE_VALUE, MobileCommand.postC("/session/:sessionId/appium/element/:id/replace_value"));
        commandRepository.put(GET_CURRENT_PACKAGE, MobileCommand.getC("/session/:sessionId/appium/device/current_package"));
        commandRepository.put(SEND_SMS, MobileCommand.postC("/session/:sessionId/appium/device/send_sms"));
        commandRepository.put(GSM_CALL, MobileCommand.postC("/session/:sessionId/appium/device/gsm_call"));
        commandRepository.put(GSM_SIGNAL, MobileCommand.postC("/session/:sessionId/appium/device/gsm_signal"));
        commandRepository.put(GSM_VOICE, MobileCommand.postC("/session/:sessionId/appium/device/gsm_voice"));
        commandRepository.put(NETWORK_SPEED, MobileCommand.postC("/session/:sessionId/appium/device/network_speed"));
        commandRepository.put(POWER_CAPACITY, MobileCommand.postC("/session/:sessionId/appium/device/power_capacity"));
        commandRepository.put(POWER_AC_STATE, MobileCommand.postC("/session/:sessionId/appium/device/power_ac"));
        commandRepository.put(TOGGLE_WIFI, MobileCommand.postC("/session/:sessionId/appium/device/toggle_wifi"));
        commandRepository.put(TOGGLE_AIRPLANE_MODE, MobileCommand.postC("/session/:sessionId/appium/device/toggle_airplane_mode"));
        commandRepository.put(TOGGLE_DATA, MobileCommand.postC("/session/:sessionId/appium/device/toggle_data"));
        commandRepository.put(COMPARE_IMAGES, MobileCommand.postC("/session/:sessionId/appium/compare_images"));
        commandRepository.put(EXECUTE_DRIVER_SCRIPT, MobileCommand.postC("/session/:sessionId/appium/execute_driver"));
        commandRepository.put(GET_ALLSESSION, MobileCommand.getC("/sessions"));
        commandRepository.put(EXECUTE_GOOGLE_CDP_COMMAND, MobileCommand.postC("/session/:sessionId/goog/cdp/execute"));
        commandRepository.put(GET_SCREEN_ORIENTATION, MobileCommand.getC("/session/:sessionId/orientation"));
        commandRepository.put(SET_SCREEN_ORIENTATION, MobileCommand.postC("/session/:sessionId/orientation"));
        commandRepository.put(GET_SCREEN_ROTATION, MobileCommand.getC("/session/:sessionId/rotation"));
        commandRepository.put(SET_SCREEN_ROTATION, MobileCommand.postC("/session/:sessionId/rotation"));
        commandRepository.put(GET_CONTEXT_HANDLES, MobileCommand.getC("/session/:sessionId/contexts"));
        commandRepository.put(GET_CURRENT_CONTEXT_HANDLE, MobileCommand.getC("/session/:sessionId/context"));
        commandRepository.put(SWITCH_TO_CONTEXT, MobileCommand.postC("/session/:sessionId/context"));
        commandRepository.put(GET_LOCATION, MobileCommand.getC("/session/:sessionId/location"));
        commandRepository.put(SET_LOCATION, MobileCommand.postC("/session/:sessionId/location"));
    }
}

