/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.client.MySqlConnectionClosedException;
import io.asyncer.r2dbc.mysql.client.MySqlConnectionException;
import io.asyncer.r2dbc.mysql.client.MySqlProtocolException;
import io.r2dbc.spi.R2dbcException;

final class ClientExceptions {
    static R2dbcException exchangeClosed() {
        return new MySqlConnectionClosedException("Cannot exchange because the connection is closed");
    }

    static R2dbcException unexpectedClosed() {
        return new MySqlConnectionClosedException("Connection unexpectedly closed");
    }

    static R2dbcException expectedClosed() {
        return new MySqlConnectionClosedException("Connection closed");
    }

    static R2dbcException unsupportedProtocol(String type) {
        return new MySqlProtocolException("Unexpected protocol message: [" + type + ']');
    }

    static R2dbcException wrap(Throwable e) {
        if (e instanceof R2dbcException) {
            return (R2dbcException)e;
        }
        return new MySqlConnectionException(e);
    }

    private ClientExceptions() {
    }
}

