/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.DateTimes;
import io.asyncer.r2dbc.mysql.codec.LocalDateCodec;
import io.asyncer.r2dbc.mysql.codec.LocalTimeCodec;
import io.asyncer.r2dbc.mysql.codec.ParametrizedCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

final class LocalDateTimeCodec
implements ParametrizedCodec<LocalDateTime> {
    static final LocalDateTime ROUND = LocalDateTime.of(LocalDateCodec.ROUND, LocalTime.MIN);
    private final ByteBufAllocator allocator;

    LocalDateTimeCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public LocalDateTime decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return LocalDateTimeCodec.decodeOrigin(value, binary, context);
    }

    @Override
    public ChronoLocalDateTime<LocalDate> decode(ByteBuf value, MySqlColumnMetadata metadata, ParameterizedType target, boolean binary, CodecContext context) {
        return LocalDateTimeCodec.decodeOrigin(value, binary, context);
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new LocalDateTimeMySqlParameter(this.allocator, (LocalDateTime)value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalDateTime;
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, ParameterizedType target) {
        return DateTimes.canDecodeChronology(metadata.getType(), target, ChronoLocalDateTime.class);
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return DateTimes.canDecodeDateTime(metadata.getType(), target, LocalDateTime.class);
    }

    @Nullable
    static LocalDateTime decodeOrigin(ByteBuf value, boolean binary, CodecContext context) {
        LocalDateTime dateTime = binary ? LocalDateTimeCodec.decodeBinary(value) : LocalDateTimeCodec.decodeText(value);
        return dateTime == null ? DateTimes.zeroDate(context.getZeroDateOption(), binary, ROUND) : dateTime;
    }

    static ByteBuf encodeBinary(ByteBufAllocator alloc, LocalDateTime value) {
        LocalTime time = value.toLocalTime();
        if (LocalTime.MIDNIGHT.equals(time)) {
            return LocalDateCodec.encodeDate(alloc, value.toLocalDate());
        }
        int nano = time.getNano();
        int bytes = nano > 0 ? 11 : 7;
        ByteBuf buf = alloc.buffer(1 + bytes);
        try {
            buf.writeByte(bytes).writeShortLE(value.getYear()).writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth()).writeByte(time.getHour()).writeByte(time.getMinute()).writeByte(time.getSecond());
            if (nano > 0) {
                return buf.writeIntLE(nano / 1000);
            }
            return buf;
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    static void encodeText(ParameterWriter writer, LocalDateTime value) {
        LocalDateCodec.encodeDate(writer, value.toLocalDate());
        writer.append(' ');
        LocalTimeCodec.encodeTime(writer, value.toLocalTime());
    }

    @Nullable
    private static LocalDateTime decodeText(ByteBuf buf) {
        LocalDate date = LocalDateCodec.readDateText(buf);
        if (date == null) {
            return null;
        }
        LocalTime time = LocalTimeCodec.readTimeText(buf);
        return LocalDateTime.of(date, time);
    }

    @Nullable
    private static LocalDateTime decodeBinary(ByteBuf buf) {
        int bytes = buf.readableBytes();
        LocalDate date = LocalDateCodec.readDateBinary(buf, bytes);
        if (date == null) {
            return null;
        }
        if (bytes < 7) {
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        byte hour = buf.readByte();
        byte minute = buf.readByte();
        byte second = buf.readByte();
        if (bytes < 11) {
            return LocalDateTime.of(date, LocalTime.of(hour, minute, second));
        }
        int nano = (int)(buf.readUnsignedIntLE() * 1000L);
        return LocalDateTime.of(date, LocalTime.of(hour, minute, second, nano));
    }

    private static final class LocalDateTimeMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final LocalDateTime value;

        private LocalDateTimeMySqlParameter(ByteBufAllocator allocator, LocalDateTime value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(this.allocator, this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.DATETIME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalDateTimeMySqlParameter)) {
                return false;
            }
            LocalDateTimeMySqlParameter that = (LocalDateTimeMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

