/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.api.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.api.MySqlRow;
import io.asyncer.r2dbc.mysql.api.MySqlRowMetadata;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.r2dbc.spi.Nullability;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

final class InsertSyntheticRow
implements MySqlRow,
MySqlRowMetadata,
MySqlColumnMetadata {
    private final Codecs codecs;
    private final String keyName;
    private final long lastInsertId;

    InsertSyntheticRow(Codecs codecs, String keyName, long lastInsertId) {
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.keyName = AssertUtils.requireNonNull(keyName, "keyName must not be null");
        this.lastInsertId = lastInsertId;
    }

    public <T> T get(int index, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        InsertSyntheticRow.assertValidIndex(index);
        return this.get0(type);
    }

    public <T> T get(String name, Class<T> type) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        this.assertValidName(name);
        return this.get0(type);
    }

    public Number get(int index) {
        InsertSyntheticRow.assertValidIndex(index);
        return (Number)this.get0(this.getType().getJavaType());
    }

    public Number get(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        this.assertValidName(name);
        return (Number)this.get0(this.getType().getJavaType());
    }

    @Override
    public boolean contains(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        return this.contains0(name);
    }

    @Override
    public MySqlRowMetadata getMetadata() {
        return this;
    }

    @Override
    public MySqlColumnMetadata getColumnMetadata(int index) {
        InsertSyntheticRow.assertValidIndex(index);
        return this;
    }

    @Override
    public MySqlColumnMetadata getColumnMetadata(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        this.assertValidName(name);
        return this;
    }

    public List<MySqlColumnMetadata> getColumnMetadatas() {
        return Collections.singletonList(this);
    }

    @Override
    public MySqlType getType() {
        return this.lastInsertId < 0L ? MySqlType.BIGINT_UNSIGNED : MySqlType.BIGINT;
    }

    @Override
    public CharCollation getCharCollation(CodecContext context) {
        return context.getClientCollation();
    }

    public String getName() {
        return this.keyName;
    }

    @Override
    public Class<?> getJavaType() {
        return this.getType().getJavaType();
    }

    public Nullability getNullability() {
        return Nullability.NON_NULL;
    }

    @Override
    public <T> T get(int index, ParameterizedType type) {
        throw new IllegalArgumentException(String.format("Cannot decode %s with last inserted ID %s", type, this.lastInsertId < 0L ? Long.toUnsignedString(this.lastInsertId) : Long.valueOf(this.lastInsertId)));
    }

    @Override
    public <T> T get(String name, ParameterizedType type) {
        throw new IllegalArgumentException(String.format("Cannot decode %s with last inserted ID %s", type, this.lastInsertId < 0L ? Long.toUnsignedString(this.lastInsertId) : Long.valueOf(this.lastInsertId)));
    }

    private boolean contains0(String name) {
        return this.keyName.equalsIgnoreCase(name);
    }

    private void assertValidName(String name) {
        if (!this.contains0(name)) {
            throw new NoSuchElementException("Column name '" + name + "' does not exist in {" + name + '}');
        }
    }

    private <T> T get0(Class<?> type) {
        return this.codecs.decodeLastInsertId(this.lastInsertId, type);
    }

    private static void assertValidIndex(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", total: 1");
        }
    }
}

