/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlSegmentResult;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.api.MySqlBatch;
import io.asyncer.r2dbc.mysql.api.MySqlResult;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.StringJoiner;
import reactor.core.publisher.Flux;

final class MySqlBatchingBatch
implements MySqlBatch {
    private final Client client;
    private final Codecs codecs;
    private final StringJoiner queries = new StringJoiner(";");

    MySqlBatchingBatch(Client client, Codecs codecs) {
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
    }

    @Override
    public MySqlBatch add(String sql) {
        AssertUtils.requireNonNull(sql, "sql must not be null");
        int index = MySqlBatchingBatch.lastNonWhitespace(sql);
        if (index >= 0 && sql.charAt(index) == ';') {
            this.queries.add(sql.substring(0, index));
        } else {
            this.queries.add(sql);
        }
        return this;
    }

    public Flux<MySqlResult> execute() {
        return QueryFlow.execute(this.client, this.getSql()).map(messages -> MySqlSegmentResult.toResult(false, this.client, this.codecs, null, (Flux<ServerMessage>)messages));
    }

    public String toString() {
        return "MySqlBatchingBatch{sql=REDACTED}";
    }

    String getSql() {
        return this.queries.toString();
    }

    private static int lastNonWhitespace(String sql) {
        int size = sql.length();
        for (int i = size - 1; i >= 0; --i) {
            if (Character.isWhitespace(sql.charAt(i))) continue;
            return i;
        }
        return -1;
    }
}

