/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class PreparedLargeDataMessage
implements ClientMessage {
    private static final int MIN_SIZE = 16;
    private static final byte LARGE_DATA_FLAG = 24;
    private final int statementId;
    private final int parameterId;
    private final Publisher<ByteBuf> data;

    public PreparedLargeDataMessage(int statementId, int parameterId, Publisher<ByteBuf> data) {
        this.statementId = statementId;
        this.parameterId = parameterId;
        this.data = AssertUtils.requireNonNull(data, "data must not be null");
    }

    public Flux<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return Flux.from(this.data).collectList().flatMapMany(values -> {
            int size = values.size();
            Object[] results = new ByteBuf[size + 1];
            long bytes = 0L;
            for (int i = 0; i < size; ++i) {
                ByteBuf byteBuf = (ByteBuf)values.get(i);
                results[i + 1] = byteBuf;
                bytes += (long)byteBuf.readableBytes();
            }
            ByteBuf header = allocator.buffer(16);
            try {
                header.writeByte(24).writeIntLE(this.statementId).writeShortLE(this.parameterId);
                VarIntUtils.writeVarInt(header, bytes);
                results[0] = header;
                header = null;
                Flux flux = Flux.fromArray((Object[])results);
                return flux;
            }
            finally {
                if (header != null) {
                    header.release();
                }
            }
        });
    }
}

