/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import com.github.luben.zstd.Zstd;
import io.asyncer.r2dbc.mysql.client.Compressor;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;

final class ZstdCompressor
implements Compressor {
    private final int compressionLevel;

    ZstdCompressor(int compressionLevel) {
        AssertUtils.require(compressionLevel >= Zstd.minCompressionLevel() && compressionLevel <= Zstd.maxCompressionLevel(), "compressionLevel must be a value of Z standard compression levels");
        this.compressionLevel = compressionLevel;
    }

    @Override
    public ByteBuf compress(ByteBuf buf) {
        ByteBuffer buffer = Zstd.compress((ByteBuffer)buf.nioBuffer(), (int)this.compressionLevel);
        return Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    @Override
    public ByteBuf decompress(ByteBuf buf, int uncompressedSize) {
        ByteBuffer buffer = Zstd.decompress((ByteBuffer)buf.nioBuffer(), (int)uncompressedSize);
        return Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    public void dispose() {
    }
}

