/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractLobMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.BlobCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.MassiveCodec;
import io.asyncer.r2dbc.mysql.codec.lob.LobUtils;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.Clob;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ClobCodec
implements MassiveCodec<Clob> {
    static final ClobCodec INSTANCE = new ClobCodec();
    private static final int MAX_MERGE = 8192;

    private ClobCodec() {
    }

    @Override
    public Class<? extends Clob> getMainClass() {
        return Clob.class;
    }

    @Override
    public Clob decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return LobUtils.createClob(value, metadata.getCharCollation(context));
    }

    @Override
    public Clob decodeMassive(List<ByteBuf> value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return LobUtils.createClob(value, metadata.getCharCollation(context));
    }

    @Override
    public boolean canDecode(MySqlReadableMetadata metadata, Class<?> target) {
        MySqlType type = metadata.getType();
        return (type.isLob() || type == MySqlType.JSON) && target.isAssignableFrom(Clob.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Clob;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new ClobMySqlParameter((Clob)value, context);
    }

    private static final class ClobMySqlParameter
    extends AbstractLobMySqlParameter {
        private final AtomicReference<Clob> clob;
        private final CodecContext context;

        private ClobMySqlParameter(Clob clob, CodecContext context) {
            this.clob = new AtomicReference<Clob>(clob);
            this.context = context;
        }

        public Flux<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Flux.defer(() -> {
                Clob clob = this.clob.getAndSet(null);
                if (clob == null) {
                    return Mono.error((Throwable)new IllegalStateException("Clob has written, can not write twice"));
                }
                return Flux.from((Publisher)clob.stream()).collectList().defaultIfEmpty(Collections.emptyList()).flatMapIterable(list -> {
                    if (list.isEmpty()) {
                        return Collections.singletonList(allocator.buffer(1).writeByte(0));
                    }
                    long bytes = 0L;
                    Charset charset = this.context.getClientCollation().getCharset();
                    ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
                    ByteBuf lastBuf = allocator.buffer();
                    try {
                        ByteBuf firstBuf = lastBuf;
                        buffers.add(firstBuf);
                        VarIntUtils.reserveVarInt(firstBuf);
                        for (CharSequence src : list) {
                            int length = src.length();
                            if (length <= 0) continue;
                            if (length > 8192 - lastBuf.readableBytes()) {
                                lastBuf = allocator.buffer();
                                buffers.add(lastBuf);
                            }
                            bytes += (long)lastBuf.writeCharSequence(src, charset);
                        }
                        VarIntUtils.setReservedVarInt(firstBuf, bytes);
                        return BlobCodec.toList(buffers);
                    }
                    catch (Throwable e) {
                        BlobCodec.releaseAll(buffers, lastBuf);
                        throw e;
                    }
                });
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.defer(() -> {
                Clob clob = this.clob.getAndSet(null);
                if (clob == null) {
                    return Mono.error((Throwable)new IllegalStateException("Clob has written, can not write twice"));
                }
                return Flux.from((Publisher)clob.stream()).doOnSubscribe(ignored -> writer.startString()).doOnNext(writer::append).then();
            });
        }

        @Override
        public MySqlType getType() {
            return MySqlType.LONGTEXT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClobMySqlParameter)) {
                return false;
            }
            ClobMySqlParameter clobValue = (ClobMySqlParameter)o;
            return Objects.equals(this.clob.get(), clobValue.clob.get());
        }

        public int hashCode() {
            Clob clob = this.clob.get();
            return clob == null ? 0 : clob.hashCode();
        }

        @Override
        protected Publisher<Void> getDiscard() {
            Clob clob = this.clob.getAndSet(null);
            return clob == null ? null : clob.discard();
        }

        @Override
        public String toString() {
            Clob clob = this.clob.get();
            return clob == null ? "Clob[MOVED]" : clob.toString();
        }
    }
}

