/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.collation;

import io.asyncer.r2dbc.mysql.collation.AbstractCharsetTarget;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import java.nio.charset.Charset;

final class CachedCharsetTarget
extends AbstractCharsetTarget {
    private final Charset charset;

    CachedCharsetTarget(int byteSize, Charset charset) {
        super(byteSize);
        this.charset = AssertUtils.requireNonNull(charset, "charset must not be null");
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachedCharsetTarget)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CachedCharsetTarget that = (CachedCharsetTarget)o;
        return this.charset.equals(that.charset);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + this.charset.hashCode();
    }

    public String toString() {
        return "CachedCharsetTarget{charset=" + this.charset + ", byteSize=" + this.byteSize + '}';
    }
}

