/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.client.SizedClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest;
import io.netty.buffer.ByteBuf;

final class SslRequest41
extends SizedClientMessage
implements SslRequest {
    private static final int RESERVED_SIZE = 19;
    private static final int MARIA_DB_CAPABILITY_SIZE = 4;
    private static final int BUF_SIZE = 32;
    private final Capability capability;
    private final int collationId;

    SslRequest41(Capability capability, int collationId) {
        AssertUtils.require(collationId > 0, "collationId must be a positive integer");
        this.capability = capability;
        this.collationId = collationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslRequest41 that = (SslRequest41)o;
        return this.collationId == that.collationId && this.capability.equals(that.capability);
    }

    public int hashCode() {
        int result = this.capability.hashCode();
        return 31 * result + this.collationId;
    }

    public String toString() {
        return "SslRequest41{capability=" + this.capability + ", collationId=" + this.collationId + '}';
    }

    @Override
    public Capability getCapability() {
        return this.capability;
    }

    @Override
    protected int size() {
        return 32;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeIntLE(this.capability.getBaseBitmap()).writeIntLE(0xFFFFFF).writeByte(this.collationId & 0xFF);
        if (this.capability.isMariaDb()) {
            buf.writeZero(19).writeIntLE(this.capability.getExtendBitmap());
        } else {
            buf.writeZero(23);
        }
    }

    int getCollationId() {
        return this.collationId;
    }
}

