/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Config;
import io.avaje.config.Configuration;
import io.avaje.config.ConfigurationSource;
import io.avaje.config.CoreExpressionEval;
import io.avaje.config.CoreListValue;
import io.avaje.config.CoreSetValue;
import io.avaje.config.FileWatch;
import io.avaje.config.InitialLoader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

final class CoreConfiguration
implements Configuration {
    private final ModifyAwareProperties properties;
    private final Map<String, OnChangeListener> callbacks = new ConcurrentHashMap<String, OnChangeListener>();
    private final CoreListValue listValue;
    private final CoreSetValue setValue;
    private boolean loadedSystemProperties;
    private FileWatch watcher;
    private Timer timer;

    CoreConfiguration(Properties source) {
        this.properties = new ModifyAwareProperties(this, source);
        this.listValue = new CoreListValue(this);
        this.setValue = new CoreSetValue(this);
    }

    static Configuration initialise() {
        InitialLoader loader = new InitialLoader();
        CoreConfiguration configuration = new CoreConfiguration(loader.load());
        configuration.loadSources();
        loader.initWatcher(configuration);
        configuration.initSystemProperties();
        configuration.logMessage(loader);
        return configuration;
    }

    private void logMessage(InitialLoader loader) {
        String watchMsg = this.watcher == null ? "" : this.watcher.toString();
        String intoMsg = this.loadedSystemProperties ? " into System properties" : "";
        Config.log.log(System.Logger.Level.INFO, "Loaded properties from {0}{1} {2}", loader.loadedFrom(), intoMsg, watchMsg);
    }

    void initSystemProperties() {
        if (this.getBool("config.load.systemProperties", false)) {
            this.loadIntoSystemProperties();
        }
    }

    private void loadSources() {
        for (ConfigurationSource source : ServiceLoader.load(ConfigurationSource.class)) {
            source.load(this);
        }
    }

    void setWatcher(FileWatch watcher) {
        this.watcher = watcher;
    }

    public String toString() {
        return "watcher:" + this.watcher + " properties:" + this.properties;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(long delayMillis, long periodMillis, Runnable runnable) {
        CoreConfiguration coreConfiguration = this;
        synchronized (coreConfiguration) {
            if (this.timer == null) {
                this.timer = new Timer("ConfigTimer", true);
            }
            this.timer.schedule((TimerTask)new Task(runnable), delayMillis, periodMillis);
        }
    }

    @Override
    public Properties eval(Properties source) {
        Configuration.ExpressionEval exprEval = InitialLoader.evalFor(source);
        Properties dest = new Properties();
        Enumeration<?> names = source.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            dest.setProperty(name, exprEval.eval(source.getProperty(name)));
        }
        return dest;
    }

    @Override
    public void evalModify(Properties properties) {
        Configuration.ExpressionEval exprEval = InitialLoader.evalFor(properties);
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String origValue = properties.getProperty(name);
            String newValue = exprEval.eval(origValue);
            if (Objects.equals(newValue, origValue)) continue;
            properties.setProperty(name, newValue);
        }
    }

    @Override
    public void loadIntoSystemProperties() {
        this.properties.loadIntoSystemProperties();
        this.loadedSystemProperties = true;
    }

    @Override
    public Properties asProperties() {
        return this.properties.asProperties();
    }

    @Override
    public Configuration.ListValue list() {
        return this.listValue;
    }

    @Override
    public Configuration.SetValue set() {
        return this.setValue;
    }

    private String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private String getRequired(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new IllegalStateException("Missing required configuration parameter [" + key + "]");
        }
        return value;
    }

    @Override
    public String get(String key) {
        return this.getRequired(key);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public Optional<String> getOptional(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public boolean getBool(String key) {
        return Boolean.parseBoolean(this.getRequired(key));
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        return this.properties.getBool(key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return Integer.parseInt(this.getRequired(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : Integer.parseInt(val);
    }

    @Override
    public long getLong(String key) {
        return Long.parseLong(this.getRequired(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : Long.parseLong(val);
    }

    @Override
    public BigDecimal getDecimal(String key) {
        return new BigDecimal(this.get(key));
    }

    @Override
    public BigDecimal getDecimal(String key, String defaultValue) {
        return new BigDecimal(this.get(key, defaultValue));
    }

    @Override
    public URL getURL(String key) {
        try {
            return new URL(this.get(key));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid url for " + key, e);
        }
    }

    @Override
    public URL getURL(String key, String defaultValue) {
        try {
            return new URL(this.get(key, defaultValue));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid url for " + key, e);
        }
    }

    @Override
    public URI getURI(String key) {
        return URI.create(this.get(key));
    }

    @Override
    public URI getURI(String key, String defaultValue) {
        return URI.create(this.get(key, defaultValue));
    }

    @Override
    public Duration getDuration(String key) {
        return Duration.parse(this.get(key));
    }

    @Override
    public Duration getDuration(String key, String defaultValue) {
        return Duration.parse(this.get(key, defaultValue));
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> cls, String key) {
        return Enum.valueOf(cls, this.get(key));
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> cls, String key, T defaultValue) {
        return Enum.valueOf(cls, this.get(key, defaultValue.name()));
    }

    @Override
    public void onChange(String key, Consumer<String> callback) {
        this.onChangeRegister(DataType.STRING, key, callback);
    }

    @Override
    public void onChangeInt(String key, Consumer<Integer> callback) {
        this.onChangeRegister(DataType.INT, key, callback);
    }

    @Override
    public void onChangeLong(String key, Consumer<Long> callback) {
        this.onChangeRegister(DataType.LONG, key, callback);
    }

    @Override
    public void onChangeBool(String key, Consumer<Boolean> callback) {
        this.onChangeRegister(DataType.BOOL, key, callback);
    }

    private void fireOnChange(String key, String value) {
        OnChangeListener listener = this.callbacks.get(key);
        if (listener != null) {
            listener.fireOnChange(value);
        }
    }

    private void onChangeRegister(DataType type, String key, Consumer<?> callback) {
        this.callbacks.computeIfAbsent(key, s -> new OnChangeListener()).register(new Callback(type, callback));
    }

    @Override
    public void setProperty(String key, String newValue) {
        this.properties.setProperty(key, newValue);
    }

    private static class ModifyAwareProperties {
        private static final String NULL_PLACEHOLDER = "NULL";
        private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
        private final Map<String, Boolean> propertiesBoolCache = new ConcurrentHashMap<String, Boolean>();
        private final Configuration.ExpressionEval eval = new CoreExpressionEval(this.properties);
        private final CoreConfiguration config;

        ModifyAwareProperties(CoreConfiguration config, Properties source) {
            this.config = config;
            this.loadAll(source);
        }

        private void loadAll(Properties source) {
            for (Map.Entry<Object, Object> entry : source.entrySet()) {
                if (entry.getValue() == null) continue;
                this.properties.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }

        public String toString() {
            return this.properties.toString();
        }

        int size() {
            return this.properties.size();
        }

        void setProperty(String key, String newValue) {
            String oldValue = (newValue = this.eval.eval(newValue)) == null ? this.properties.remove(key) : this.properties.put(key, newValue);
            if (!Objects.equals(newValue, oldValue)) {
                Config.log.log(System.Logger.Level.TRACE, "setProperty key:{0} value:{1}", key, newValue);
                this.propertiesBoolCache.remove(key);
                this.config.fireOnChange(key, newValue);
            }
        }

        boolean getBool(String key, boolean defaultValue) {
            Boolean cachedValue = this.propertiesBoolCache.get(key);
            if (cachedValue != null) {
                return cachedValue;
            }
            String rawValue = this.getProperty(key);
            boolean value = rawValue == null ? defaultValue : Boolean.parseBoolean(rawValue);
            this.propertiesBoolCache.put(key, value);
            return value;
        }

        String getProperty(String key) {
            return this.getProperty(key, null);
        }

        String getProperty(String key, String defaultValue) {
            String val = this.properties.get(key);
            if (val == null) {
                val = System.getProperty(key);
                if (val == null) {
                    val = defaultValue == null ? NULL_PLACEHOLDER : defaultValue;
                }
                this.properties.put(key, val);
            }
            return val != NULL_PLACEHOLDER ? val : defaultValue;
        }

        void loadIntoSystemProperties() {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String value = entry.getValue();
                if (value == NULL_PLACEHOLDER) continue;
                System.setProperty(entry.getKey(), value);
            }
        }

        Properties asProperties() {
            Properties props = new Properties();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String value = entry.getValue();
                if (value == NULL_PLACEHOLDER) continue;
                props.setProperty(entry.getKey(), value);
            }
            return props;
        }
    }

    private static class Task
    extends TimerTask {
        private final Runnable runnable;

        private Task(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                Config.log.log(System.Logger.Level.ERROR, "Error executing timer task", (Throwable)e);
            }
        }
    }

    private static enum DataType {
        INT,
        LONG,
        BOOL,
        STRING;

    }

    private static class OnChangeListener {
        private final List<Callback> callbacks = new ArrayList<Callback>();

        private OnChangeListener() {
        }

        void register(Callback callback) {
            this.callbacks.add(callback);
        }

        void fireOnChange(String value) {
            for (Callback callback : this.callbacks) {
                callback.fireOnChange(value);
            }
        }
    }

    private static class Callback {
        private final DataType type;
        private final Consumer consumer;

        Callback(DataType type, Consumer consumer) {
            this.type = type;
            this.consumer = consumer;
        }

        void fireOnChange(String value) {
            this.consumer.accept(this.convert(value));
        }

        private Object convert(String value) {
            switch (this.type) {
                case INT: {
                    return Integer.valueOf(value);
                }
                case LONG: {
                    return Long.valueOf(value);
                }
                case BOOL: {
                    return Boolean.valueOf(value);
                }
            }
            return value;
        }
    }
}

