/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.support;

import io.awspring.cloud.messaging.core.SqsMessageHeaders;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;

public class SqsHeadersMethodArgumentResolver
extends HeadersMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return super.supportsParameter(parameter) || SqsMessageHeaders.class == parameter.getParameterType();
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Object resolvedParameter = Objects.requireNonNull(super.resolveArgument(parameter, message));
        if (Map.class.isAssignableFrom(resolvedParameter.getClass()) && SqsMessageHeaders.class != resolvedParameter.getClass()) {
            return new SqsMessageHeaders((Map)resolvedParameter);
        }
        return resolvedParameter;
    }
}

