/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3.crossregion;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ConcurrentLruMap<K, V> {
    private final int sizeLimit;
    private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();
    private final ConcurrentLinkedDeque<K> queue = new ConcurrentLinkedDeque();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int size;

    ConcurrentLruMap(int sizeLimit) {
        Assert.isTrue((sizeLimit >= 0 ? 1 : 0) != 0, (String)"Cache size limit must not be negative");
        this.sizeLimit = sizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V get(K key) {
        V cached = this.cache.get(key);
        if (cached != null) {
            this.lock.readLock().lock();
            try {
                if (this.queue.removeLastOccurrence(key)) {
                    this.queue.offer(key);
                }
                V v = cached;
                return v;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            K leastUsed;
            if (this.size == this.sizeLimit && (leastUsed = this.queue.poll()) != null) {
                this.cache.remove(leastUsed);
            }
            this.queue.offer(key);
            this.cache.put(key, value);
            this.size = this.cache.size();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean contains(K key) {
        return this.cache.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        this.lock.writeLock().lock();
        try {
            boolean wasPresent = this.cache.remove(key) != null;
            this.queue.remove(key);
            this.size = this.cache.size();
            boolean bl = wasPresent;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
            this.queue.clear();
            this.size = 0;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        return this.size;
    }

    public int sizeLimit() {
        return this.sizeLimit;
    }

    Object[] queue() {
        return this.queue.toArray();
    }

    ConcurrentHashMap<K, V> cache() {
        return new ConcurrentHashMap<K, V>(this.cache);
    }
}

