/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.aop.jdk;

import io.basc.framework.aop.MethodInterceptor;
import io.basc.framework.aop.Proxy;
import io.basc.framework.aop.ProxyFactory;
import io.basc.framework.aop.jdk.JdkProxy;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.ClassUtils;
import java.util.Arrays;

public class JdkProxyFactory
implements ProxyFactory {
    public static final String PROXY_NAME_PREFIX = "java.lang.reflect.Proxy";

    @Override
    public boolean canProxy(Class<?> clazz) {
        return clazz.isInterface();
    }

    @Override
    public boolean isProxy(Class<?> clazz) {
        return java.lang.reflect.Proxy.isProxyClass(clazz);
    }

    private final Class<?>[] mergeInterfaces(Class<?> clazz, Class<?>[] interfaces) {
        if (ArrayUtils.isEmpty(interfaces)) {
            if (clazz.isInterface()) {
                return new Class[]{clazz};
            }
            return new Class[0];
        }
        Class[] array = new Class[1 + interfaces.length];
        int index = 0;
        array[index++] = clazz;
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] == clazz) continue;
            array[index++] = interfaces[i];
        }
        if (index <= interfaces.length) {
            return Arrays.copyOfRange(array, 0, index);
        }
        return array;
    }

    @Override
    public Proxy getProxy(Class<?> clazz, Class<?>[] interfaces, MethodInterceptor methodInterceptor) {
        return new JdkProxy(clazz, this.mergeInterfaces(clazz, interfaces), methodInterceptor);
    }

    @Override
    public Class<?> getUserClass(Class<?> clazz) {
        return clazz.getInterfaces()[0];
    }

    @Override
    public boolean isProxy(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return className.startsWith(PROXY_NAME_PREFIX);
    }

    @Override
    public Class<?> getUserClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return this.getUserClass(ClassUtils.forName(className, classLoader));
    }
}

