/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.aop.support;

import io.basc.framework.aop.Aop;
import io.basc.framework.aop.MethodInterceptor;
import io.basc.framework.aop.Proxy;
import io.basc.framework.aop.ProxyFactory;
import io.basc.framework.aop.ProxyInstanceTarget;
import io.basc.framework.aop.support.AbstractProxy;
import io.basc.framework.aop.support.AbstractProxyMethodInvoker;
import io.basc.framework.aop.support.ConfigurableMethodInterceptor;
import io.basc.framework.core.reflect.MethodInvoker;
import io.basc.framework.factory.InstanceException;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.StaticSupplier;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;

public abstract class AbstractAop
implements Aop {
    public abstract ProxyFactory getProxyFactory();

    @Override
    public final boolean canProxy(Class<?> clazz) {
        return this.getProxyFactory().canProxy(clazz);
    }

    @Override
    public final Class<?> getUserClass(Class<?> clazz) {
        return this.getProxyFactory().getUserClass(clazz);
    }

    @Override
    public final Class<?> getUserClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return this.getProxyFactory().getUserClass(className, classLoader);
    }

    @Override
    public final boolean isProxy(Class<?> clazz) {
        return this.getProxyFactory().isProxy(clazz);
    }

    @Override
    public final boolean isProxy(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return this.getProxyFactory().isProxy(className, classLoader);
    }

    @Override
    public Proxy getProxy(Class<?> clazz, Class<?>[] interfaces, MethodInterceptor methodInterceptor) {
        if (methodInterceptor == null) {
            return this.getProxyFactory().getProxy(clazz, interfaces, this.getMethodInterceptor());
        }
        ConfigurableMethodInterceptor interceptors = new ConfigurableMethodInterceptor();
        interceptors.addMethodInterceptor(this.getMethodInterceptor());
        interceptors.addMethodInterceptor(methodInterceptor);
        return this.getProxyFactory().getProxy(clazz, interfaces, interceptors);
    }

    @Override
    public final Proxy getProxy(Class<?> clazz) {
        return this.getProxy(clazz, null, null);
    }

    @Override
    public <T> Proxy getProxy(Class<? extends T> clazz, Supplier<? extends T> instanceSupplier, Class<?>[] interfaces, MethodInterceptor methodInterceptor) {
        return new InstanceProxy(clazz, interfaces, methodInterceptor, instanceSupplier);
    }

    @Override
    public final <T> Proxy getProxy(Class<? extends T> clazz, Supplier<? extends T> instanceSupplier) {
        return this.getProxy(clazz, (T)instanceSupplier, null, null);
    }

    @Override
    public final <T> Proxy getProxy(Class<? extends T> clazz, T instance) {
        return this.getProxy(clazz, instance, null, null);
    }

    @Override
    public <T> Proxy getProxy(Class<? extends T> clazz, T instance, Class<?>[] interfaces, MethodInterceptor methodInterceptor) {
        ConfigurableMethodInterceptor interceptors = new ConfigurableMethodInterceptor();
        interceptors.setInstance(instance);
        if (!this.isProxy(instance)) {
            interceptors.addMethodInterceptor(this.getMethodInterceptor());
        }
        interceptors.addMethodInterceptor(methodInterceptor);
        return this.getProxyFactory().getProxy(clazz, ArrayUtils.merge(interfaces, ProxyInstanceTarget.CLASSES), interceptors);
    }

    protected boolean isProxyMethod(Object instance, Method method) {
        boolean isProxy;
        boolean bl = isProxy = !Modifier.isPrivate(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !Modifier.isFinal(method.getModifiers()) && !Modifier.isNative(method.getModifiers());
        if (isProxy) {
            isProxy = instance != null && this.isProxy(instance);
        }
        return isProxy;
    }

    @Override
    public final <T> MethodInvoker getProxyMethod(Class<? extends T> targetClass, T instance, Method method) {
        return this.getProxyMethod(targetClass, instance, method, null);
    }

    @Override
    public final <T> MethodInvoker getProxyMethod(Class<? extends T> targetClass, Supplier<? extends T> instanceSupplier, Method method) {
        return this.getProxyMethod(targetClass, instanceSupplier, method, (MethodInterceptor)null);
    }

    @Override
    public <T> MethodInvoker getProxyMethod(Class<? extends T> targetClass, T instance, Method method, MethodInterceptor methodInterceptor) {
        return this.getProxyMethod(targetClass, (Supplier<? extends T>)new StaticSupplier<T>(instance), method, methodInterceptor);
    }

    @Override
    public <T> MethodInvoker getProxyMethod(Class<? extends T> targetClass, Supplier<? extends T> instanceSupplier, Method method, MethodInterceptor methodInterceptor) {
        return new ProxyMethod(instanceSupplier, targetClass, method, methodInterceptor);
    }

    protected final class ProxyMethod
    extends AbstractProxyMethodInvoker {
        private static final long serialVersionUID = 1L;
        private final MethodInterceptor methodInterceptor;

        public ProxyMethod(Supplier<?> instanceSupplier, Class<?> sourceClass, Method method, MethodInterceptor methodInterceptor) {
            super(instanceSupplier, sourceClass, method);
            this.methodInterceptor = methodInterceptor;
        }

        @Override
        protected MethodInterceptor getMethodInterceptor(MethodInvoker invoker) {
            if (AbstractAop.this.isProxyMethod(invoker.getInstance(), invoker.getMethod())) {
                return this.methodInterceptor;
            }
            if (this.methodInterceptor == null) {
                return AbstractAop.this.getMethodInterceptor();
            }
            ConfigurableMethodInterceptor interceptors = new ConfigurableMethodInterceptor();
            interceptors.addMethodInterceptor(AbstractAop.this.getMethodInterceptor());
            interceptors.addMethodInterceptor(this.methodInterceptor);
            return interceptors;
        }
    }

    protected final class InstanceProxy
    extends AbstractProxy {
        private final Supplier<?> instanceSupplier;

        public InstanceProxy(Class<?> targetClass, Class<?>[] interfaces, MethodInterceptor methodInterceptor, Supplier<?> instanceSupplier) {
            super(targetClass, interfaces, methodInterceptor);
            this.instanceSupplier = instanceSupplier;
        }

        private Proxy getProxy() {
            Object instance = this.instanceSupplier.get();
            ConfigurableMethodInterceptor interceptors = new ConfigurableMethodInterceptor();
            interceptors.setInstance(instance);
            if (!AbstractAop.this.isProxy(instance)) {
                interceptors.addMethodInterceptor(AbstractAop.this.getMethodInterceptor());
            }
            interceptors.addMethodInterceptor(this.getMethodInterceptor());
            return AbstractAop.this.getProxyFactory().getProxy(this.getSourceClass(), ArrayUtils.merge(this.getInterfaces(), ProxyInstanceTarget.CLASSES), interceptors);
        }

        @Override
        public Object create() throws InstanceException {
            return this.getProxy().create();
        }

        @Override
        protected Object createInternal(Class<?>[] parameterTypes, Object[] params) {
            return this.getProxy().create(parameterTypes, params);
        }
    }
}

