/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.aop.support;

import io.basc.framework.aop.MethodInterceptor;
import io.basc.framework.aop.support.AbstractMethodInterceptors;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.MultiIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConfigurableMethodInterceptor
extends AbstractMethodInterceptors
implements Configurable {
    private static final long serialVersionUID = 1L;
    private volatile List<MethodInterceptor> defaultInterceptors;
    private volatile List<MethodInterceptor> interceptors;
    private boolean configured;

    @Override
    public synchronized void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.defaultInterceptors = serviceLoaderFactory.getServiceLoader(MethodInterceptor.class).toList();
        this.configured = true;
    }

    @Override
    public Iterator<MethodInterceptor> iterator() {
        if (this.interceptors == null && this.defaultInterceptors == null) {
            return Collections.emptyIterator();
        }
        ArrayList<Iterator<Iterator<Object>>> iterators = new ArrayList<Iterator<Iterator<Object>>>(this.size());
        if (this.interceptors != null) {
            for (MethodInterceptor interceptor : this.interceptors) {
                if (interceptor == null) continue;
                if (interceptor instanceof AbstractMethodInterceptors) {
                    iterators.add(((AbstractMethodInterceptors)interceptor).iterator());
                    continue;
                }
                iterators.add(Arrays.asList(interceptor).iterator());
            }
        }
        if (this.defaultInterceptors != null) {
            for (MethodInterceptor interceptor : this.defaultInterceptors) {
                if (interceptor == null) continue;
                if (interceptor instanceof AbstractMethodInterceptors) {
                    iterators.add(((AbstractMethodInterceptors)interceptor).iterator());
                    continue;
                }
                iterators.add(Arrays.asList(interceptor).iterator());
            }
        }
        return new MultiIterator<MethodInterceptor>(iterators);
    }

    public int size() {
        return CollectionUtils.size(this.interceptors) + CollectionUtils.size(this.defaultInterceptors);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.interceptors == null) {
            ConfigurableMethodInterceptor configurableMethodInterceptor = this;
            synchronized (configurableMethodInterceptor) {
                if (this.interceptors == null) {
                    this.interceptors = new CopyOnWriteArrayList<MethodInterceptor>();
                }
            }
        }
    }

    public void addMethodInterceptor(MethodInterceptor methodInterceptor) {
        this.init();
        this.interceptors.add(methodInterceptor);
    }

    public void addFirstMethodInterceptor(MethodInterceptor methodInterceptor) {
        this.init();
        this.interceptors.add(0, methodInterceptor);
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }
}

