/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.aop.support;

import io.basc.framework.aop.AopPolicy;
import io.basc.framework.aop.ConfigurableAop;
import io.basc.framework.aop.ProxyFactory;
import io.basc.framework.aop.support.AbstractAop;
import io.basc.framework.aop.support.ConfigurableMethodInterceptor;
import io.basc.framework.aop.support.ProxyUtils;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.ServiceLoaderFactory;
import java.util.Iterator;

public class DefaultConfigurableAop
extends AbstractAop
implements ConfigurableAop,
Configurable {
    private final ProxyFactory proxyFactory;
    private final ConfigurableMethodInterceptor configurableMethodInterceptor = new ConfigurableMethodInterceptor();
    private final ConfigurableServices<AopPolicy> policies = new ConfigurableServices<AopPolicy>(AopPolicy.class);

    public DefaultConfigurableAop() {
        this(ProxyUtils.getFactory());
    }

    public DefaultConfigurableAop(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.configurableMethodInterceptor.configure(serviceLoaderFactory);
        this.policies.configure(serviceLoaderFactory);
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public ConfigurableMethodInterceptor getMethodInterceptor() {
        return this.configurableMethodInterceptor;
    }

    @Override
    public void addAopPolicy(AopPolicy aopPolicy) {
        this.policies.addService(aopPolicy);
    }

    public Iterator<AopPolicy> getPolicyIterator() {
        return this.policies.iterator();
    }

    @Override
    public boolean isProxy(Object instance) {
        if (instance == null) {
            return false;
        }
        Iterator<AopPolicy> iterator = this.getPolicyIterator();
        while (iterator.hasNext()) {
            AopPolicy aopPolicy = iterator.next();
            if (!aopPolicy.isProxy(instance)) continue;
            return true;
        }
        return super.isProxy(instance);
    }

    @Override
    public boolean isConfigured() {
        return this.configurableMethodInterceptor.isConfigured() && this.policies.isConfigured();
    }
}

