/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.NestedDecoder;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@FunctionalInterface
public interface Decoder<E, D> {
    public D decode(E var1) throws DecodeException;

    default public List<D> decodeAll(Collection<? extends E> sources) throws DecodeException {
        if (CollectionUtils.isEmpty(sources)) {
            return Collections.emptyList();
        }
        return sources.stream().map(e -> this.decode(e)).collect(Collectors.toList());
    }

    @Nullable
    default public D[] decodeAll(E ... sources) throws DecodeException {
        return this.toDecodeProcessor().processAll(sources);
    }

    default public <F> Decoder<F, D> fromDecoder(Decoder<F, E> decoder) {
        return new NestedDecoder(decoder, this);
    }

    default public <T> Decoder<E, T> toDecoder(Decoder<D, T> decoder) {
        return new NestedDecoder(this, decoder);
    }

    default public Processor<E, D, DecodeException> toDecodeProcessor() {
        return o -> this.decode(o);
    }

    public static <R> Decoder<R, R> identity() {
        return e -> e;
    }
}

