/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec;

import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.NestedEncoder;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Validator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@FunctionalInterface
public interface Encoder<D, E>
extends Validator<D, E> {
    public E encode(D var1) throws EncodeException;

    @Override
    default public boolean verify(D source, E encode) throws EncodeException {
        return ObjectUtils.equals(this.encode(source), encode);
    }

    default public List<E> encodeAll(Collection<? extends D> sources) throws EncodeException {
        if (CollectionUtils.isEmpty(sources)) {
            return Collections.emptyList();
        }
        return sources.stream().map(e -> this.encode(e)).collect(Collectors.toList());
    }

    @Nullable
    default public E[] encodeAll(D ... sources) throws EncodeException {
        return this.toEncodeProcessor().processAll(sources);
    }

    default public <F> Encoder<F, E> fromEncoder(Encoder<F, D> encoder) {
        return new NestedEncoder(encoder, this);
    }

    default public <T> Encoder<D, T> toEncoder(Encoder<E, T> encoder) {
        return new NestedEncoder(this, encoder);
    }

    default public Processor<D, E, EncodeException> toEncodeProcessor() {
        return o -> this.encode(o);
    }

    public static <R> Encoder<R, R> identity() {
        return e -> e;
    }
}

