/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.decode;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.MultipleDecoder;
import io.basc.framework.codec.decode.FromBytesDecoder;
import io.basc.framework.codec.decode.NestedBytesDecoder;
import io.basc.framework.codec.decode.ToBytesDecoder;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.IOUtils;
import io.basc.framework.io.UnsafeByteArrayInputStream;
import io.basc.framework.io.UnsafeByteArrayOutputStream;
import io.basc.framework.util.Assert;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface BytesDecoder
extends FromBytesDecoder<byte[]>,
ToBytesDecoder<byte[]>,
MultipleDecoder<byte[]> {
    default public BytesDecoder toDecoder(BytesDecoder decoder) {
        return new NestedBytesDecoder(this, decoder);
    }

    default public BytesDecoder fromDecoder(BytesDecoder decoder) {
        return new NestedBytesDecoder(decoder, this);
    }

    @Override
    default public byte[] decode(byte[] source) throws DecodeException {
        return (byte[])FromBytesDecoder.super.decode(source);
    }

    default public void decode(byte[] source, File target, int count) throws DecodeException, IOException {
        UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(source);
        this.decode((InputStream)input, source.length, target, count);
    }

    @Override
    default public void decode(byte[] source, OutputStream target) throws DecodeException, IOException {
        UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(source);
        this.decode((InputStream)input, source.length, target);
    }

    default public void decode(byte[] source, OutputStream target, int count) throws DecodeException, IOException {
        UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(source);
        this.decode((InputStream)input, source.length, target, count);
    }

    @Override
    default public byte[] decode(InputStream source, int bufferSize) throws IOException, DecodeException {
        UnsafeByteArrayOutputStream target = new UnsafeByteArrayOutputStream();
        this.decode(source, bufferSize, (OutputStream)target);
        return target.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public byte[] decode(File source, int bufferSize) throws IOException, DecodeException {
        try (FileInputStream fis = new FileInputStream(source);){
            byte[] byArray = this.decode((InputStream)fis, bufferSize);
            return byArray;
        }
    }

    default public byte[] decode(InputStream source, int bufferSize, int count) throws IOException, DecodeException {
        byte[] v = this.decode(source, bufferSize);
        if (count > 1) {
            return this.decode(v, count - 1);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public byte[] decode(File source, int bufferSize, int count) throws IOException, DecodeException {
        try (FileInputStream fis = new FileInputStream(source);){
            byte[] byArray = this.decode((InputStream)fis, bufferSize, count);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void decode(File source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws IOException, DecodeException, E {
        try (FileInputStream fis = new FileInputStream(source);){
            this.decode((InputStream)fis, bufferSize, targetProcessor);
        }
    }

    @Override
    default public void decode(InputStream source, OutputStream target) throws DecodeException, IOException {
        this.decode(source, 4096, target);
    }

    default public void decode(InputStream source, OutputStream target, int count) throws DecodeException, IOException {
        this.decode(source, 4096, target, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(File source, int bufferSize, OutputStream target) throws DecodeException, IOException {
        FileInputStream fis = new FileInputStream(source);
        try {
            this.decode((InputStream)fis, bufferSize, target);
        }
        finally {
            IOUtils.close((Closeable)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(File source, int bufferSize, OutputStream target, int count) throws DecodeException, IOException {
        FileInputStream fis = new FileInputStream(source);
        try {
            this.decode((InputStream)fis, bufferSize, target, count);
        }
        finally {
            IOUtils.close((Closeable)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(File source, int bufferSize, File target) throws DecodeException, IOException {
        InputStream fis = null;
        OutputStream fos = null;
        try {
            this.decode(fis, bufferSize, fos);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis, fos);
            throw throwable;
        }
        IOUtils.close(fis, fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(File source, int bufferSize, File target, int count) throws DecodeException, IOException {
        InputStream fis = null;
        OutputStream fos = null;
        try {
            this.decode(fis, bufferSize, fos, count);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis, fos);
            throw throwable;
        }
        IOUtils.close(fis, fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(InputStream source, int bufferSize, File target) throws DecodeException, IOException {
        FileOutputStream fos = new FileOutputStream(target);
        try {
            this.decode(source, bufferSize, (OutputStream)fos);
        }
        finally {
            IOUtils.close((Closeable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(InputStream source, int bufferSize, File target, int count) throws DecodeException, IOException {
        FileOutputStream fos = new FileOutputStream(target);
        try {
            this.decode(source, bufferSize, (OutputStream)fos, count);
        }
        finally {
            IOUtils.close((Closeable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(InputStream source, int bufferSize, OutputStream target, int count) throws DecodeException, IOException {
        Assert.isTrue(count > 0, "Count must be greater than 0");
        if (count == 1) {
            this.decode(source, bufferSize, target);
            return;
        }
        File firstFile = File.createTempFile("encode", "count.0");
        this.decode(source, bufferSize, firstFile);
        File lastFile = firstFile;
        for (int i = 1; i < count - 1; ++i) {
            File targetFile = File.createTempFile("encode", "count." + i);
            try {
                this.decode(lastFile, bufferSize, targetFile);
            }
            finally {
                lastFile.delete();
            }
            lastFile = targetFile;
        }
        try {
            this.decode(lastFile, bufferSize, target);
        }
        finally {
            lastFile.delete();
        }
    }

    public void decode(InputStream var1, int var2, OutputStream var3) throws DecodeException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void decode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor, int count) throws DecodeException, IOException, E {
        Assert.isTrue(count > 0, "Count must be greater than 0");
        if (count == 1) {
            this.decode(source, bufferSize, targetProcessor);
            return;
        }
        File firstFile = File.createTempFile("encode", "count.0");
        this.decode(source, bufferSize, firstFile);
        File lastFile = firstFile;
        for (int i = 1; i < count - 1; ++i) {
            File targetFile = File.createTempFile("encode", "count." + i);
            try {
                this.decode(lastFile, bufferSize, targetFile);
            }
            finally {
                lastFile.delete();
            }
            lastFile = targetFile;
        }
        try {
            this.decode(lastFile, bufferSize, targetProcessor);
        }
        finally {
            lastFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void decode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws DecodeException, IOException, E {
        File tempFile = File.createTempFile("decode", "processor");
        try {
            this.decode(source, bufferSize, tempFile);
            FileUtils.read(tempFile, bufferSize, targetProcessor);
        }
        finally {
            tempFile.delete();
        }
    }
}

