/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.decode;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.Decoder;
import io.basc.framework.codec.decode.NestedFromBytesDecoder;
import io.basc.framework.io.IOUtils;
import io.basc.framework.io.Resource;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public interface FromBytesDecoder<D>
extends Decoder<byte[], D> {
    public D decode(InputStream var1, int var2) throws IOException, DecodeException;

    @Override
    default public D decode(InputStream source) throws IOException, DecodeException {
        return this.decode(source, 4096);
    }

    @Override
    default public D decode(byte[] source) throws DecodeException {
        if (source == null) {
            return null;
        }
        try {
            return this.decode(new ByteArrayInputStream(source), source.length);
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    default public <T> FromBytesDecoder<T> toDecoder(Decoder<D, T> decoder) {
        return new NestedFromBytesDecoder(this, decoder);
    }

    @Override
    default public D decode(File source) throws IOException, DecodeException {
        return this.decode(source, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public D decode(File source, int bufferSize) throws IOException, DecodeException {
        D d;
        if (!source.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            d = this.decode(fis, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis);
            throw throwable;
        }
        IOUtils.close((Closeable)fis);
        return d;
    }

    @Override
    default public D decode(Resource source) throws IOException, DecodeException {
        return (D)source.read(is -> this.decode((InputStream)is));
    }

    default public D decode(Resource source, int bufferSize) throws IOException, DecodeException {
        return (D)source.read(is -> this.decode((InputStream)is, bufferSize));
    }
}

