/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.decode;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.Decoder;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.UnsafeByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public interface ToBytesDecoder<E>
extends Decoder<E, byte[]> {
    @Override
    default public byte[] decode(E source) throws DecodeException {
        UnsafeByteArrayOutputStream target = new UnsafeByteArrayOutputStream();
        try {
            this.decode(source, target);
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
        return target.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void decode(E source, File target) throws DecodeException, IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(target);
            this.decode(source, fos);
        }
    }

    public void decode(E var1, OutputStream var2) throws DecodeException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <S extends Throwable> void decode(E source, BufferProcessor<byte[], S> targetProcessor) throws DecodeException, IOException, S {
        File tempFile = File.createTempFile("decode", "processor");
        try {
            this.decode(source, tempFile);
            FileUtils.read(tempFile, targetProcessor);
        }
        finally {
            tempFile.delete();
        }
    }
}

