/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.encode;

import io.basc.framework.codec.CodecException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.encode.BytesEncoder;
import io.basc.framework.io.IOUtils;
import io.basc.framework.lang.NamedThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestEncoder
implements BytesEncoder,
Cloneable {
    private final NamedThreadLocal<MessageDigest> threadLocal;
    protected final String algorithm;
    private byte[] secretKey;

    public MessageDigestEncoder(String algorithm) {
        this.algorithm = algorithm;
        this.threadLocal = new NamedThreadLocal(algorithm);
    }

    protected MessageDigestEncoder(MessageDigestEncoder encoder) {
        this.threadLocal = encoder.threadLocal;
        this.algorithm = encoder.algorithm;
        this.secretKey = encoder.secretKey;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public MessageDigestEncoder clone() {
        return new MessageDigestEncoder(this);
    }

    public MessageDigest getMessageDigest() {
        MessageDigest messageDigest = (MessageDigest)this.threadLocal.get();
        if (messageDigest != null) {
            messageDigest.reset();
            return messageDigest;
        }
        messageDigest = MessageDigestEncoder.getMessageDigest(this.algorithm);
        this.threadLocal.set(messageDigest);
        return messageDigest;
    }

    public MessageDigestEncoder wrapperSecretKey(byte[] secretKey) {
        MessageDigestEncoder signer = this.clone();
        signer.secretKey = secretKey;
        return signer;
    }

    public static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CodecException(algorithm, e);
        }
    }

    public String toString() {
        return this.algorithm;
    }

    @Override
    public byte[] encode(InputStream source, int bufferSize) throws IOException, EncodeException {
        MessageDigest messageDigest = this.getMessageDigest();
        if (this.secretKey != null) {
            messageDigest.update(this.secretKey);
        }
        IOUtils.read(source, bufferSize, messageDigest::update);
        return messageDigest.digest();
    }

    @Override
    public void encode(InputStream source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        byte[] res = this.encode(source, bufferSize);
        target.write(res);
    }
}

