/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.StringUtils;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateCodec
implements Codec<Date, String> {
    private final Locale locale;
    private final TimeZone timeZone;
    private final DateFormatSymbols dateFormatSymbols;
    private final String pattern;

    public DateCodec(@Nullable String pattern) {
        this(pattern, null, null, null);
    }

    public DateCodec(@Nullable String pattern, @Nullable TimeZone timeZone, @Nullable Locale locale, @Nullable DateFormatSymbols dateFormatSymbols) {
        this.locale = locale;
        this.timeZone = timeZone;
        this.dateFormatSymbols = dateFormatSymbols;
        this.pattern = pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getPattern() {
        return this.pattern;
    }

    public SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat;
        SimpleDateFormat simpleDateFormat = StringUtils.hasText(this.pattern) ? (this.locale == null ? new SimpleDateFormat(this.pattern) : new SimpleDateFormat(this.pattern, this.locale)) : (dateFormat = new SimpleDateFormat());
        if (this.timeZone != null) {
            dateFormat.setTimeZone(this.timeZone);
        }
        if (this.dateFormatSymbols != null) {
            dateFormat.setDateFormatSymbols(this.dateFormatSymbols);
        }
        return dateFormat;
    }

    @Override
    public String encode(Date source) throws EncodeException {
        if (source == null) {
            return null;
        }
        return this.getDateFormat().format(source);
    }

    @Override
    public Date decode(String source) throws DecodeException {
        if (!StringUtils.hasText(source)) {
            return null;
        }
        try {
            return this.getDateFormat().parse(source);
        }
        catch (ParseException e) {
            throw new DecodeException(source, e);
        }
    }

    public long parse(String source) throws DecodeException {
        Date date = this.decode(source);
        return date == null ? 0L : date.getTime();
    }

    public String format(long source) throws EncodeException {
        Date d = new Date();
        d.setTime(source);
        return this.encode(d);
    }

    public boolean contains(Date source, Date target) {
        if (source == null) {
            return target == null;
        }
        if (target == null) {
            return source == null;
        }
        if (source == target) {
            return true;
        }
        SimpleDateFormat sdf = this.getDateFormat();
        String date1 = sdf.format(source);
        String date2 = sdf.format(target);
        return date1.equals(date2);
    }

    public boolean contains(long source, long target) {
        return this.contains(new Date(source), new Date(target));
    }
}

