/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.NestedCodec;
import io.basc.framework.codec.support.BytesCodec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NestedBytesCodec
extends NestedCodec<BytesCodec, BytesCodec, byte[], byte[], byte[]>
implements BytesCodec {
    private final int count;

    public NestedBytesCodec(BytesCodec parent, BytesCodec codec) {
        this(parent, codec, 1);
    }

    public NestedBytesCodec(BytesCodec parent, BytesCodec codec, int count) {
        super(parent, codec);
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(InputStream source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        if (this.parent == null) {
            ((BytesCodec)this.codec).encode(source, bufferSize, target, this.count);
            return;
        }
        File tempFile = File.createTempFile("nested", "decode");
        try {
            ((BytesCodec)this.parent).encode(source, bufferSize, tempFile, this.count);
            ((BytesCodec)this.codec).encode(tempFile, bufferSize, target, this.count);
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(InputStream source, int bufferSize, OutputStream target) throws DecodeException, IOException {
        if (this.parent == null) {
            ((BytesCodec)this.codec).decode(source, bufferSize, target, this.count);
            return;
        }
        File tempFile = File.createTempFile("nested", "decode");
        try {
            ((BytesCodec)this.codec).decode(source, bufferSize, tempFile, this.count);
            ((BytesCodec)this.parent).decode(tempFile, bufferSize, target, this.count);
        }
        finally {
            tempFile.delete();
        }
    }
}

