/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.CodecException;
import io.basc.framework.codec.support.BytesCodec;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public abstract class SecurityCodec
implements BytesCodec {
    public static KeyFactory getKeyFactory(String algorithm) {
        try {
            return KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CodecException(algorithm, e);
        }
    }

    public static PrivateKey getPrivateKey(String algorithm, byte[] privateKey) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = SecurityCodec.getKeyFactory(algorithm);
        try {
            return keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CodecException(algorithm, e);
        }
    }

    public static PublicKey getPublicKey(String algorithm, byte[] publicKey) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory keyFactory = SecurityCodec.getKeyFactory(algorithm);
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CodecException(algorithm, e);
        }
    }
}

