/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert;

import io.basc.framework.core.MethodParameter;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.core.annotation.AnnotatedElementUtils;
import io.basc.framework.core.annotation.AnnotatedElements;
import io.basc.framework.core.annotation.AnnotationArrayAnnotatedElement;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.XUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class TypeDescriptor
implements AnnotatedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, TypeDescriptor> commonTypesCache = new HashMap(32);
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final AnnotatedElement annotatedElement;

    public TypeDescriptor(MethodParameter methodParameter) {
        this.resolvableType = ResolvableType.forMethodParameter(methodParameter);
        this.type = this.resolvableType.resolve(methodParameter.getNestedParameterType());
        this.annotatedElement = new AnnotationArrayAnnotatedElement(methodParameter.getParameterIndex() == -1 ? methodParameter.getMethodAnnotations() : methodParameter.getParameterAnnotations());
    }

    public TypeDescriptor(Field field) {
        this.resolvableType = ResolvableType.forField(field);
        this.type = this.resolvableType.resolve(field.getType());
        this.annotatedElement = new AnnotationArrayAnnotatedElement(field);
    }

    public TypeDescriptor(ParameterDescriptor parameterDescriptor) {
        this.resolvableType = ResolvableType.forType(parameterDescriptor.getGenericType());
        this.type = this.resolvableType.resolve(parameterDescriptor.getType());
        AnnotatedElement arrayAnnnotation = XUtils.getDelegate(parameterDescriptor, AnnotationArrayAnnotatedElement.class);
        this.annotatedElement = arrayAnnnotation == null ? new AnnotationArrayAnnotatedElement(parameterDescriptor) : arrayAnnnotation;
    }

    public TypeDescriptor(ResolvableType resolvableType, @Nullable Class<?> type, @Nullable AnnotatedElement annotatedElement) {
        this.resolvableType = resolvableType;
        Class<?> clazz = this.type = type != null ? type : resolvableType.toClass();
        this.annotatedElement = annotatedElement == null ? AnnotatedElements.EMPTY : (annotatedElement instanceof Serializable ? annotatedElement : new AnnotationArrayAnnotatedElement(annotatedElement));
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Object getSource() {
        return this.resolvableType.getSource();
    }

    public TypeDescriptor getNested(int nestingLevel) {
        return new TypeDescriptor(this.resolvableType.getNested(nestingLevel), null, this.annotatedElement);
    }

    public TypeDescriptor getGeneric(int ... indexes) {
        return new TypeDescriptor(this.resolvableType.getGeneric(indexes), null, this.annotatedElement);
    }

    public TypeDescriptor narrow(@Nullable Object value) {
        if (value == null) {
            return this;
        }
        ResolvableType narrowed = ResolvableType.forType(value.getClass(), this.getResolvableType());
        return new TypeDescriptor(narrowed, value.getClass(), this);
    }

    public TypeDescriptor convert(ResolvableType type) {
        return new TypeDescriptor(type, type.getRawClass(), this);
    }

    @Nullable
    public TypeDescriptor upcast(@Nullable Class<?> superType) {
        if (superType == null) {
            return null;
        }
        Assert.isAssignable(superType, this.getType());
        return new TypeDescriptor(this.getResolvableType().as(superType), superType, this);
    }

    public String getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isEnum() {
        return this.getType().isEnum();
    }

    public boolean isGeneric() {
        return this.getResolvableType().hasGenerics();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotatedElement.getAnnotations();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return AnnotatedElementUtils.hasAnnotation(this.annotatedElement, annotationType);
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return AnnotatedElementUtils.getMergedAnnotation(this.annotatedElement, annotationType);
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean typesAssignable = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!typesAssignable) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && this.isNestedAssignable(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(@Nullable TypeDescriptor nestedTypeDescriptor, @Nullable TypeDescriptor otherNestedTypeDescriptor) {
        return nestedTypeDescriptor == null || otherNestedTypeDescriptor == null || nestedTypeDescriptor.isAssignableTo(otherNestedTypeDescriptor);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    @Nullable
    public TypeDescriptor getElementTypeDescriptor() {
        if (this.getResolvableType().isArray()) {
            return new TypeDescriptor(this.getResolvableType().getComponentType(), null, this);
        }
        if (Stream.class.isAssignableFrom(this.getType())) {
            return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().as(Stream.class).getGeneric(0));
        }
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asCollection().getGeneric(0));
    }

    @Nullable
    public TypeDescriptor elementTypeDescriptor(Object element) {
        return this.narrow(element, this.getElementTypeDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Nullable
    public TypeDescriptor getMapKeyTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(0));
    }

    @Nullable
    public TypeDescriptor getMapKeyTypeDescriptor(Object mapKey) {
        return this.narrow(mapKey, this.getMapKeyTypeDescriptor());
    }

    @Nullable
    public TypeDescriptor getMapValueTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(1));
    }

    @Nullable
    public TypeDescriptor getMapValueTypeDescriptor(Object mapValue) {
        return this.narrow(mapValue, this.getMapValueTypeDescriptor());
    }

    @Nullable
    private TypeDescriptor narrow(@Nullable Object value, @Nullable TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(value);
        }
        if (value != null) {
            return this.narrow(value);
        }
        return null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor otherDesc = (TypeDescriptor)other;
        if (this.getType() != otherDesc.getType()) {
            return false;
        }
        if (!this.annotationsMatch(otherDesc)) {
            return false;
        }
        if (this.isCollection() || this.isArray()) {
            return ObjectUtils.equals(this.getElementTypeDescriptor(), otherDesc.getElementTypeDescriptor());
        }
        if (this.isMap()) {
            return ObjectUtils.equals(this.getMapKeyTypeDescriptor(), otherDesc.getMapKeyTypeDescriptor()) && ObjectUtils.equals(this.getMapValueTypeDescriptor(), otherDesc.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean annotationsMatch(TypeDescriptor otherDesc) {
        Annotation[] otherAnns;
        Annotation[] anns = this.getAnnotations();
        if (anns == (otherAnns = otherDesc.getAnnotations())) {
            return true;
        }
        if (anns.length != otherAnns.length) {
            return false;
        }
        if (anns.length > 0) {
            for (int i = 0; i < anns.length; ++i) {
                if (this.annotationEquals(anns[i], otherAnns[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean annotationEquals(Annotation ann, Annotation otherAnn) {
        return ann == otherAnn || ann.getClass() == otherAnn.getClass() && ann.equals(otherAnn);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Annotation ann : this.getAnnotations()) {
            builder.append("@").append(ann.annotationType().getName()).append(' ');
        }
        builder.append(this.getResolvableType().toString());
        return builder.toString();
    }

    @Nullable
    public static TypeDescriptor forObject(@Nullable Object source) {
        return source != null ? TypeDescriptor.valueOf(source.getClass()) : null;
    }

    public static TypeDescriptor forMethodReturnType(Method method) {
        return new TypeDescriptor(ResolvableType.forMethodReturnType(method), null, method);
    }

    public static TypeDescriptor valueOf(@Nullable Class<?> type) {
        TypeDescriptor desc;
        if (type == null) {
            type = Object.class;
        }
        return (desc = commonTypesCache.get(type)) != null ? desc : new TypeDescriptor(ResolvableType.forClass(type), null, type);
    }

    public static TypeDescriptor valueOf(@Nullable Type type) {
        if (type == null) {
            type = Object.class;
        }
        return new TypeDescriptor(ResolvableType.forType((Type)type), null, null);
    }

    public static TypeDescriptor valueOf(@Nullable ResolvableType type) {
        if (type == null) {
            type = ResolvableType.forClass(Object.class);
        }
        return new TypeDescriptor(type, null, null);
    }

    public static TypeDescriptor collection(Class<?> collectionType, @Nullable TypeDescriptor elementTypeDescriptor) {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType element = elementTypeDescriptor != null ? elementTypeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(collectionType, element), null, null);
    }

    public static TypeDescriptor collection(Class<?> collectionType, @Nullable ResolvableType elementType) {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType element = elementType != null ? elementType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(collectionType, element), null, null);
    }

    public static TypeDescriptor collection(Class<?> collectionType, @Nullable Class<?> elementType) {
        return TypeDescriptor.collection(collectionType, ResolvableType.forClass(elementType));
    }

    public static TypeDescriptor map(Class<?> mapType, @Nullable TypeDescriptor keyTypeDescriptor, @Nullable TypeDescriptor valueTypeDescriptor) {
        Assert.notNull(mapType, "Map type must not be null");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type must be a [java.util.Map]");
        }
        ResolvableType key = keyTypeDescriptor != null ? keyTypeDescriptor.resolvableType : null;
        ResolvableType value = valueTypeDescriptor != null ? valueTypeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(mapType, key, value), null, null);
    }

    public static TypeDescriptor map(Class<?> mapType, @Nullable ResolvableType keyType, @Nullable ResolvableType valueType) {
        Assert.notNull(mapType, "Map type must not be null");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type must be a [java.util.Map]");
        }
        ResolvableType key = keyType != null ? keyType : null;
        ResolvableType value = valueType != null ? valueType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(mapType, key, value), null, null);
    }

    public static TypeDescriptor map(Class<?> mapType, @Nullable Class<?> keyType, @Nullable Class<?> valueType) {
        return TypeDescriptor.map(mapType, ResolvableType.forClass(keyType), ResolvableType.forClass(valueType));
    }

    @Nullable
    public static TypeDescriptor array(@Nullable TypeDescriptor elementTypeDescriptor) {
        if (elementTypeDescriptor == null) {
            return null;
        }
        return new TypeDescriptor(ResolvableType.forArrayComponent(elementTypeDescriptor.resolvableType), null, elementTypeDescriptor);
    }

    public static TypeDescriptor array(@Nullable ResolvableType elementType) {
        if (elementType == null) {
            return null;
        }
        return new TypeDescriptor(elementType, null, null);
    }

    public static TypeDescriptor array(@Nullable Class<?> elementType) {
        if (elementType == null) {
            return null;
        }
        return TypeDescriptor.array(ResolvableType.forClass(elementType));
    }

    @Nullable
    public static TypeDescriptor nested(MethodParameter methodParameter, int nestingLevel) {
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("MethodParameter nesting level must be 1: use the nestingLevel parameter to specify the desired nestingLevel for nested type traversal");
        }
        return TypeDescriptor.nested(new TypeDescriptor(methodParameter), nestingLevel);
    }

    @Nullable
    public static TypeDescriptor nested(Field field, int nestingLevel) {
        return TypeDescriptor.nested(new TypeDescriptor(field), nestingLevel);
    }

    @Nullable
    private static TypeDescriptor nested(TypeDescriptor typeDescriptor, int nestingLevel) {
        ResolvableType nested = typeDescriptor.resolvableType;
        for (int i = 0; i < nestingLevel; ++i) {
            if (Object.class == nested.getType()) continue;
            nested = nested.getNested(2);
        }
        if (nested == ResolvableType.NONE) {
            return null;
        }
        return TypeDescriptor.getRelatedIfResolvable(typeDescriptor, nested);
    }

    @Nullable
    private static TypeDescriptor getRelatedIfResolvable(TypeDescriptor source, ResolvableType type) {
        if (type.resolve() == null) {
            return null;
        }
        return new TypeDescriptor(type, null, source);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotatedElement.getDeclaredAnnotations();
    }

    static {
        for (Class<?> preCachedClass : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(preCachedClass, TypeDescriptor.valueOf(preCachedClass));
        }
    }
}

