/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.lang;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.ConversionFailedException;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.ConditionalConversionService;
import io.basc.framework.convert.lang.ConvertiblePair;
import io.basc.framework.util.Processor;
import java.util.Collections;
import java.util.Set;

public class ConverterConversionService
implements ConditionalConversionService {
    private final Processor converter;
    private final Set<ConvertiblePair> convertibleTypes;

    public <S, T> ConverterConversionService(Class<S> sourceType, Class<T> targetType, Processor<S, ? extends T, ? extends Throwable> converter) {
        this.convertibleTypes = Collections.singleton(new ConvertiblePair(sourceType, targetType));
        this.converter = converter;
    }

    @Override
    public Set<ConvertiblePair> getConvertibleTypes() {
        return this.convertibleTypes;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.converter.process(source);
        }
        catch (Throwable e) {
            if (e instanceof ConversionException) {
                throw (ConversionException)e;
            }
            throw new ConversionFailedException(sourceType, targetType, source, e);
        }
    }

    public String toString() {
        return "<" + String.valueOf(this.converter) + ">" + this.convertibleTypes.toString();
    }
}

