/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.lang;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.ConversionFailedException;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.annotation.DateFormat;
import io.basc.framework.convert.lang.AbstractConversionService;
import io.basc.framework.convert.lang.ConditionalConversionService;
import io.basc.framework.convert.lang.ConvertiblePair;
import io.basc.framework.util.NumberUtils;
import io.basc.framework.util.TimeUtils;
import io.basc.framework.value.Value;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DateFormatConversionService
extends AbstractConversionService
implements ConditionalConversionService {
    private static final Set<ConvertiblePair> CONVERTIBLE_PAIRS = new HashSet<ConvertiblePair>(4);

    private boolean canConvert(Class<?> type) {
        return type == String.class || Date.class.isAssignableFrom(type) || NumberUtils.isNumber(type);
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType == null || targetType == null) {
            return false;
        }
        return (targetType.isAnnotationPresent(DateFormat.class) || sourceType.isAnnotationPresent(DateFormat.class)) && this.canConvert(sourceType.getType()) && this.canConvert(targetType.getType());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws ConversionException {
        if (source == null || sourceType == null) {
            return null;
        }
        if (sourceType.getType() == String.class) {
            if (targetType.getType() == Date.class) {
                return this.stringToDate((String)source, sourceType, targetType);
            }
            if (NumberUtils.isNumber(targetType.getType())) {
                return this.stringToNumber((String)source, sourceType, targetType);
            }
        }
        if (sourceType.getType() == Date.class) {
            if (targetType.getType() == String.class) {
                return this.dateToString((Date)source, sourceType, targetType);
            }
            if (NumberUtils.isNumber(targetType.getType())) {
                return this.dateToNumber((Date)source, sourceType, targetType);
            }
        }
        if (NumberUtils.isNumber(sourceType.getType())) {
            if (targetType.getType() == String.class) {
                return this.numberToString(source, sourceType, targetType);
            }
            if (targetType.getType() == Date.class) {
                return this.numberToString(source, sourceType, targetType);
            }
            if (NumberUtils.isNumber(targetType.getType())) {
                return Value.of(source).getAsObject(targetType);
            }
        }
        if (!this.getConversionService().canConvert(sourceType, TypeDescriptor.valueOf(Date.class))) {
            throw new ConversionFailedException(sourceType, targetType, source, null);
        }
        Date date = (Date)this.getConversionService().convert(source, sourceType, TypeDescriptor.valueOf(Date.class));
        return this.convert(date, sourceType.narrow(date), targetType);
    }

    private Date stringToDate(String source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        DateFormat sourceFormat = sourceType.getAnnotation(DateFormat.class);
        DateFormat targetFormat = targetType.getAnnotation(DateFormat.class);
        if (sourceFormat == null) {
            if (targetFormat == null) {
                return TimeUtils.convert(source);
            }
            return TimeUtils.parse(source, targetFormat.value());
        }
        if (targetFormat == null) {
            return TimeUtils.parse(source, sourceFormat.value());
        }
        source = TimeUtils.format(TimeUtils.parse(source, sourceFormat.value()), sourceFormat.value());
        return TimeUtils.parse(source, targetFormat.value());
    }

    private Object stringToNumber(String source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Date date = this.stringToDate(source, sourceType, targetType.narrow(Date.class));
        return this.dateToNumber(date, sourceType.narrow(date), targetType);
    }

    private String dateToString(Date source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        DateFormat sourceFormat = sourceType.getAnnotation(DateFormat.class);
        DateFormat targetFormat = targetType.getAnnotation(DateFormat.class);
        if (targetFormat == null) {
            if (sourceFormat == null) {
                return String.valueOf(source);
            }
            return TimeUtils.format(source, sourceFormat.value());
        }
        if (sourceFormat != null) {
            source = TimeUtils.parse(TimeUtils.format(source, sourceFormat.value()), sourceFormat.value());
        }
        return TimeUtils.format(source, targetFormat.value());
    }

    private Object dateToNumber(Date source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Value.of((Object)source.getTime()).getAsObject(targetType);
    }

    private Date numberToDate(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        long time = Value.of(source).getAsLong();
        return new Date(time);
    }

    private String numberToString(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Date date = this.numberToDate(source, sourceType, targetType);
        DateFormat sourceFormat = sourceType.getAnnotation(DateFormat.class);
        DateFormat targetFormat = targetType.getAnnotation(DateFormat.class);
        if (targetFormat == null) {
            if (sourceFormat == null) {
                return String.valueOf(date);
            }
            return TimeUtils.format(date, sourceFormat.value());
        }
        if (sourceFormat == null) {
            return TimeUtils.format(date, targetFormat.value());
        }
        date = TimeUtils.parse(TimeUtils.format(date, sourceFormat.value()), sourceFormat.value());
        return TimeUtils.format(date, targetFormat.value());
    }

    @Override
    public Set<ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_PAIRS;
    }

    static {
        CONVERTIBLE_PAIRS.add(new ConvertiblePair(String.class, Date.class));
        CONVERTIBLE_PAIRS.add(new ConvertiblePair(Date.class, String.class));
    }
}

