/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.support;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.ConversionServiceAware;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.ResolvableType;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;

class LocalDateTimeConversion
implements ConversionService,
ConversionServiceAware {
    private ConversionService conversionService;

    LocalDateTimeConversion() {
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType == null) {
            return false;
        }
        return LocalDateTime.class.isAssignableFrom(sourceType.getType()) && this.conversionService.canConvert(sourceType.convert(ResolvableType.forClass(Date.class)), targetType);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws ConversionException {
        io.basc.framework.convert.annotation.ZoneOffset offset = targetType.getAnnotation(io.basc.framework.convert.annotation.ZoneOffset.class);
        ZoneOffset zoneOffset = offset == null ? OffsetDateTime.now().getOffset() : ZoneOffset.of(offset.value());
        long milli = ((LocalDateTime)source).toInstant(zoneOffset).toEpochMilli();
        return this.conversionService.convert(new Date(milli), sourceType.convert(ResolvableType.forClass(Date.class)), targetType);
    }
}

