/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.support;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.value.Value;

class ValueConversionService
implements ConversionService {
    private final ConversionService conversionService;

    public ValueConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Value value = Value.of(source, sourceType, this.conversionService);
        if (targetType.getType() == Value.class) {
            return value;
        }
        return value.getAsObject(targetType);
    }

    private boolean isValueType(Class<?> type, boolean isAssignableFrom) {
        if (Value.isBaseType(type)) {
            return true;
        }
        if (isAssignableFrom) {
            return Value.class.isAssignableFrom(type);
        }
        return Value.class == type;
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType == null || targetType == null) {
            return false;
        }
        return this.isValueType(sourceType.getType(), true) || this.isValueType(targetType.getType(), false);
    }
}

