/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core;

import io.basc.framework.core.Ordered;
import io.basc.framework.core.PriorityOrdered;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.comparator.CompareUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OrderComparator
implements Comparator<Object> {
    public static final OrderComparator INSTANCE = new OrderComparator();

    public Comparator<Object> withSourceProvider(final OrderSourceProvider sourceProvider) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return OrderComparator.this.doCompare(o1, o2, sourceProvider);
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.doCompare(o1, o2, null);
    }

    private int doCompare(Object o1, Object o2, OrderSourceProvider sourceProvider) {
        boolean p1 = o1 instanceof PriorityOrdered;
        boolean p2 = o2 instanceof PriorityOrdered;
        if (p1 && !p2) {
            return -1;
        }
        if (p2 && !p1) {
            return 1;
        }
        int i1 = this.getOrder(o1, sourceProvider);
        int i2 = this.getOrder(o2, sourceProvider);
        return this.compare(i1, i2);
    }

    @Override
    public int compare(int o1, int o2) {
        return CompareUtils.compare(o1, o2, false);
    }

    private int getOrder(Object obj, OrderSourceProvider sourceProvider) {
        Integer order = null;
        if (sourceProvider != null) {
            Object orderSource = sourceProvider.getOrderSource(obj);
            if (orderSource != null && orderSource.getClass().isArray()) {
                Object source;
                Object[] sources;
                Object[] objectArray = sources = ObjectUtils.toObjectArray(orderSource);
                int n = objectArray.length;
                for (int i = 0; i < n && (order = this.findOrder(source = objectArray[i])) == null; ++i) {
                }
            } else {
                order = this.findOrder(orderSource);
            }
        }
        return order != null ? order.intValue() : this.getOrder(obj);
    }

    protected int getOrder(Object obj) {
        Integer order = this.findOrder(obj);
        return order != null ? order : 0;
    }

    protected Integer findOrder(Object obj) {
        return obj instanceof Ordered ? Integer.valueOf(((Ordered)obj).getOrder()) : null;
    }

    public Integer getPriority(Object obj) {
        return null;
    }

    public static void sort(List<?> list) {
        if (list.size() > 1) {
            Collections.sort(list, INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value) {
        if (value instanceof Object[]) {
            OrderComparator.sort((Object[])value);
        } else if (value instanceof List) {
            OrderComparator.sort((List)value);
        }
    }

    public static interface OrderSourceProvider {
        public Object getOrderSource(Object var1);
    }
}

