/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core;

import io.basc.framework.core.ParameterNameDiscoverer;
import io.basc.framework.factory.support.SimpleServiceLoaderFactory;
import io.basc.framework.lang.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrioritizedParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final ParameterNameDiscoverer[] PARAMETER_NAME_DISCOVERERS = (ParameterNameDiscoverer[])SimpleServiceLoaderFactory.INSTANCE.getServiceLoader(ParameterNameDiscoverer.class).toArray(ParameterNameDiscoverer[]::new);
    private final List<ParameterNameDiscoverer> parameterNameDiscoverers = new ArrayList<ParameterNameDiscoverer>(2);

    public void addDiscoverer(ParameterNameDiscoverer pnd) {
        this.parameterNameDiscoverers.add(pnd);
    }

    protected String[] getParameterNames(List<ParameterNameDiscoverer> parameterNameDiscoverers, Method method) {
        for (ParameterNameDiscoverer pnd : parameterNameDiscoverers) {
            String[] result = pnd.getParameterNames(method);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public String[] getParameterNames(Method method) {
        String[] result = this.getParameterNames(Arrays.asList(PARAMETER_NAME_DISCOVERERS), method);
        if (result == null) {
            result = this.getParameterNames(this.parameterNameDiscoverers, method);
        }
        return result;
    }

    protected String[] getParameterNames(List<ParameterNameDiscoverer> parameterNameDiscoverers, Constructor<?> ctor) {
        for (ParameterNameDiscoverer pnd : parameterNameDiscoverers) {
            String[] result = pnd.getParameterNames(ctor);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> ctor) {
        String[] result = this.getParameterNames(Arrays.asList(PARAMETER_NAME_DISCOVERERS), ctor);
        if (result == null) {
            result = this.getParameterNames(this.parameterNameDiscoverers, ctor);
        }
        return result;
    }
}

