/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.annotation;

import io.basc.framework.core.annotation.EmptyAnnotatedElement;
import io.basc.framework.core.annotation.MergedAnnotations;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.UnsafeArrayList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public abstract class AnnotatedElements
implements AnnotatedElement {
    public static AnnotatedElement EMPTY = new EmptyAnnotatedElement();

    public static <A extends AnnotatedElement, T extends Annotation> T getAnnotation(Iterator<? extends A> iterator, Class<? extends T> annotationClass, Function<? super A, ? extends T> processor) {
        Annotation annotation = null;
        ArrayList<Annotation> list = null;
        while (iterator.hasNext()) {
            Annotation ann;
            AnnotatedElement annotatedElement = (AnnotatedElement)iterator.next();
            if (annotatedElement == null || (ann = (Annotation)processor.apply(annotatedElement)) == null) continue;
            if (annotation == null) {
                annotation = ann;
                continue;
            }
            if (list == null) {
                list = new ArrayList<Annotation>(2);
                list.add(annotation);
            }
            list.add(ann);
        }
        if (list == null) {
            return (T)annotation;
        }
        return MergedAnnotations.from(list.toArray(new Annotation[0])).get(annotationClass).synthesize();
    }

    public static <A extends AnnotatedElement, T> List<T> getAnnotations(Iterator<? extends A> iterator, Function<? super A, ? extends T[]> processor) {
        if (iterator == null || processor == null) {
            return Collections.emptyList();
        }
        T[] first = null;
        AbstractList list = null;
        while (iterator.hasNext()) {
            T[] array;
            AnnotatedElement annotatedElement = (AnnotatedElement)iterator.next();
            if (annotatedElement == null || (array = processor.apply(annotatedElement)) == null || array.length == 0) continue;
            if (first == null) {
                first = array;
                continue;
            }
            if (list == null) {
                list = new ArrayList(4);
                list.addAll(new UnsafeArrayList<T>(first));
            }
            list.addAll(new UnsafeArrayList<T>(array));
        }
        return list == null ? (first == null ? Collections.emptyList() : new UnsafeArrayList<T>(first)) : list;
    }

    protected abstract Iterator<? extends AnnotatedElement> annotationElementIterator();

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)AnnotatedElements.getAnnotation(this.annotationElementIterator(), annotationClass, e -> e.getAnnotation(annotationClass));
    }

    @Override
    public Annotation[] getAnnotations() {
        return AnnotatedElements.getAnnotations(this.annotationElementIterator(), e -> e.getAnnotations()).toArray(new Annotation[0]);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])AnnotatedElements.getAnnotations(this.annotationElementIterator(), e -> e.getAnnotationsByType(annotationClass)).toArray();
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return (T)AnnotatedElements.getAnnotation(this.annotationElementIterator(), annotationClass, e -> e.getDeclaredAnnotation(annotationClass));
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotatedElements.getAnnotations(this.annotationElementIterator(), e -> e.getDeclaredAnnotations()).toArray(new Annotation[0]);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])AnnotatedElements.getAnnotations(this.annotationElementIterator(), e -> e.getDeclaredAnnotationsByType(annotationClass)).toArray();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        Iterator<? extends AnnotatedElement> iterator = this.annotationElementIterator();
        if (iterator == null) {
            return false;
        }
        while (iterator.hasNext()) {
            AnnotatedElement annotatedElement = iterator.next();
            if (annotatedElement == null || !annotatedElement.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return CollectionUtils.hashCode(this.annotationElementIterator());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AnnotatedElements) {
            return CollectionUtils.equals(this.annotationElementIterator(), ((AnnotatedElements)obj).annotationElementIterator());
        }
        return false;
    }
}

