/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.reflect;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ConcurrentReferenceHashMap;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Processor;
import io.basc.framework.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Supplier;

public class ReflectionApi
implements Supplier<Object> {
    private final Class<?> declaringClass;
    private final Processor<Class<?>, Object, ? extends Throwable> processor;
    private static final Processor<Class<?>, Object, Throwable> UNSAFE_PROCESSOR = C -> {
        Field f = C.getDeclaredField("theUnsafe");
        ReflectionUtils.makeAccessible(f);
        return f.get(null);
    };
    public static final ReflectionApi UNSAFE = new ReflectionApi(ClassUtils.getClass("sun.misc.Unsafe", null), UNSAFE_PROCESSOR);
    private static final Method ALLOCATE_INSTANCE_METHOD = UNSAFE.getMethod("allocateInstance", Class.class);
    private static final Processor<Class<?>, Object, Throwable> REFLECTION_FACTORY_PROCESSOR = c -> {
        Method method = c.getMethod("getReflectionFactory", new Class[0]);
        return method.invoke(null, new Object[0]);
    };
    public static final ReflectionApi REFLECTION_FACTORY = new ReflectionApi(ClassUtils.getClass("sun.reflect.ReflectionFactory", null), REFLECTION_FACTORY_PROCESSOR);
    private static final Method NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD = REFLECTION_FACTORY.getMethod("newConstructorForSerialization", Class.class, Constructor.class);
    private static final ConcurrentReferenceHashMap<Class<?>, Constructor<?>> CONSTRUCTOR_MAP = new ConcurrentReferenceHashMap(128);

    public ReflectionApi(@Nullable Class<?> declaringClass, @Nullable Processor<Class<?>, Object, ? extends Throwable> processor) {
        this.declaringClass = declaringClass;
        this.processor = processor;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isAvailable() {
        return this.declaringClass != null;
    }

    @Override
    public Object get() {
        if (this.declaringClass == null) {
            throw new IllegalStateException("Unavailable API");
        }
        if (this.processor == null) {
            return null;
        }
        try {
            return this.processor.process(this.declaringClass);
        }
        catch (Throwable e) {
            throw new IllegalStateException(this.declaringClass.getName(), e);
        }
    }

    @Nullable
    public Method getMethod(String name, Class<?> ... parameterTypes) {
        if (this.declaringClass == null) {
            return null;
        }
        return ReflectionUtils.findMethod(this.declaringClass, name, parameterTypes);
    }

    public Object invoke(Method method, Object ... args) {
        Assert.requiredArgument(this.isAvailable(), "declaringClass");
        Assert.requiredArgument(method != null, "method");
        ReflectionUtils.makeAccessible(method);
        return ReflectionUtils.invoke(method, Modifier.isStatic(method.getModifiers()) ? null : this.get(), args);
    }

    public Object invoke(String methodName, Object ... params) {
        Assert.requiredArgument(this.isAvailable(), "declaringClass");
        Assert.requiredArgument(StringUtils.hasText(methodName), "methodName");
        Assert.requiredArgument(params != null && params.length % 2 == 0, "params");
        Object[] parameterTypes = new Class[params.length / 2];
        System.arraycopy(params, 0, parameterTypes, 0, parameterTypes.length);
        Method method = this.getMethod(methodName, (Class<?>[])parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException(this.declaringClass + " not found method[" + methodName + "] parameterTypes" + Arrays.toString(parameterTypes));
        }
        Object[] args = new Object[parameterTypes.length];
        System.arraycopy(params, parameterTypes.length, args, 0, args.length);
        return this.invoke(method, args);
    }

    public static <T> T allocateInstance(Class<T> type) {
        Assert.isTrue(UNSAFE.isAvailable());
        Assert.requiredArgument(type != null, "type");
        return type.cast(UNSAFE.invoke(ALLOCATE_INSTANCE_METHOD, type));
    }

    public static <T> Constructor<T> newConstructorForSerialization(Class<T> type) {
        Assert.isTrue(REFLECTION_FACTORY.isAvailable());
        Assert.requiredArgument(type != null, "type");
        return (Constructor)REFLECTION_FACTORY.invoke(NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD, type, ReflectionUtils.OBJECT_CONSTRUCTOR);
    }

    public static <T> Constructor<T> getConstructorForSerialization(Class<T> type) {
        Constructor<Object> constructor = CONSTRUCTOR_MAP.get(type);
        if (constructor == null && REFLECTION_FACTORY.isAvailable()) {
            constructor = ReflectionApi.newConstructorForSerialization(type);
        }
        if (constructor == null) {
            return null;
        }
        Constructor<?> old = CONSTRUCTOR_MAP.putIfAbsent(type, constructor);
        if (old == null) {
            CONSTRUCTOR_MAP.purgeUnreferencedEntries();
        } else {
            constructor = old;
        }
        return constructor;
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(Class<T> type) {
        Assert.requiredArgument(type != null, "type");
        Constructor<T> constructor = ReflectionUtils.getDeclaredConstructor(type);
        if (constructor == null) {
            constructor = ReflectionApi.getConstructorForSerialization(type);
        }
        return constructor;
    }

    public static boolean isInstance(Class<?> type) {
        return type != null && !type.isPrimitive() && !type.isArray() && !type.isAnnotation() && !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
    }

    public static <T> T newInstance(Class<T> type) throws UnsupportedException {
        return ReflectionApi.newInstance(type, ObjectUtils.EMPTY_ARRAY);
    }

    public static <T> T newInstance(Class<T> type, Object ... params) throws UnsupportedException {
        Constructor<T> constructor;
        if (params != null && params.length > 0) {
            try {
                return ReflectionUtils.newInstanceWithParams(type, params);
            }
            catch (UnsupportedException unsupportedException) {
                // empty catch block
            }
        }
        if ((constructor = ReflectionApi.getConstructor(type)) != null) {
            try {
                return ReflectionUtils.newInstance(constructor, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (UNSAFE.isAvailable()) {
            try {
                return ReflectionApi.allocateInstance(type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ReflectionUtils.newInstanceWithNullValues(type);
    }
}

