/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.reflect;

import io.basc.framework.core.Members;
import io.basc.framework.core.reflect.ExecutableMatchingResults;
import io.basc.framework.core.reflect.MemberScopeComparator;
import io.basc.framework.core.reflect.ReflectionApi;
import io.basc.framework.lang.NestedExceptionUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ConcurrentReferenceHashMap;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Source;
import io.basc.framework.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class ReflectionUtils {
    private static final Method[] CLASS_PRESENT_METHODS = (Method[])ReflectionUtils.getMethods(Class.class).stream().filter(method -> !Modifier.isStatic(method.getModifiers()) && !Modifier.isNative(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && method.getParameterTypes().length == 0).toArray(Method[]::new);
    private static final ConcurrentReferenceHashMap<Class<?>, Constructor<?>> CONSTRUCTOR_MAP = new ConcurrentReferenceHashMap(128);
    public static final Predicate<Member> ENTITY_MEMBER = m -> !Modifier.isStatic(m.getModifiers());
    private static volatile Logger logger;
    public static final Comparator<Member> MEMBER_SCOPE_COMPARATOR;
    public static final Constructor<Object> OBJECT_CONSTRUCTOR;
    private static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";

    public static <T> T clone(Members<Field> members, T source, boolean deep) {
        Assert.requiredArgument(members != null, "members");
        if (source == null) {
            return null;
        }
        Object target = ReflectionApi.newInstance(source.getClass());
        ReflectionUtils.clone(members, source, target, deep);
        return (T)target;
    }

    public static <T> void clone(Members<Field> members, T source, T target, boolean deep) {
        Assert.requiredArgument(members != null, "members");
        if (source == null || target == null) {
            return;
        }
        ((Members)members.all()).stream().filter(ENTITY_MEMBER).forEach(f -> {
            try {
                Object value = ReflectionUtils.get(f, source);
                value = value == source ? target : ObjectUtils.clone(value, deep);
                ReflectionUtils.set(f, target, value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Should never get here", e);
            }
        });
    }

    public static <T> T clone(T source) {
        return ReflectionUtils.clone(source, false);
    }

    public static <T> T clone(T source, boolean deep) {
        if (source == null) {
            return null;
        }
        return ReflectionUtils.clone(ReflectionUtils.getDeclaredFields(source.getClass()).withAll(), source, deep);
    }

    public static <T> void clone(T source, T target, boolean deep) {
        Assert.requiredArgument(target != null, "target");
        if (source == null) {
            return;
        }
        ReflectionUtils.clone(ReflectionUtils.getDeclaredFields(target.getClass()).withAll(), source, target, deep);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull((Object)method, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean equals(Class<? extends T> entityClass, T left, T right) {
        return ReflectionUtils.equals(entityClass, left, right, true);
    }

    public static <T> boolean equals(Class<? extends T> entityClass, T left, T right, boolean deep) {
        Assert.requiredArgument(entityClass != null, "entityClass");
        return ReflectionUtils.equals(ReflectionUtils.getDeclaredFields(entityClass).withSuperclass(), left, right, deep);
    }

    public static <T> boolean equals(Members<Field> members, T left, T right) {
        return ReflectionUtils.equals(members, left, right, true);
    }

    public static <T, E> boolean equals(Members<Field> members, T left, T right, boolean deep) {
        Assert.requiredArgument(members != null, "members");
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Iterator iterator = ((Members)members.all()).stream().filter(ENTITY_MEMBER).iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (ObjectUtils.equals(ReflectionUtils.get(field, left), ReflectionUtils.get(field, right), deep)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T left, T right) {
        return ReflectionUtils.equals(left, right, true);
    }

    public static <T> boolean equals(T left, T right, boolean deep) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return ReflectionUtils.equals(left.getClass(), left, right, deep);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)name, "Method name must not be null");
        return ((Members)ReflectionUtils.getDeclaredMethods(clazz).withAll().all()).stream().filter(method -> name.equals(method.getName()) && (paramTypes == null || ClassUtils.isAssignable(paramTypes == null ? new Class[]{} : paramTypes, method.getParameterTypes()))).findFirst().orElse(null);
    }

    public static Object get(Field field, Object target) {
        ReflectionUtils.makeAccessible(field);
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static <T extends Executable> ExecutableMatchingResults<T> getByParams(Stream<T> sourceStream, boolean strict, Object ... params) throws NoSuchMethodException {
        Stream<ExecutableMatchingResults<T>> stream = ReflectionUtils.matchParams(sourceStream, strict, params);
        try {
            return stream.findFirst().get();
        }
        catch (NoSuchElementException e) {
            throw e.getLocalizedMessage() == null ? new NoSuchMethodException() : new NoSuchMethodException(e.getLocalizedMessage());
        }
    }

    public static Method getCloneMethod(Cloneable source) {
        if (source == null) {
            return null;
        }
        Method method = ReflectionUtils.findMethod(source.getClass(), "clone", new Class[0]);
        if (method == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(method.getReturnType(), source)) {
            return method;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> type) {
        Constructor<T> constructor = ReflectionUtils.getDeclaredConstructor(type);
        return constructor != null && Modifier.isPublic(constructor.getModifiers()) ? constructor : null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return ReflectionUtils.getConstructor(type);
        }
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return ((Members)ReflectionUtils.getConstructors(type).all()).stream().filter(e -> ClassUtils.isAssignable(e.getParameterTypes(), parameterTypes)).findFirst().orElse(null);
        }
    }

    public static <T> Constructor<T> getConstructor(String className, @Nullable ClassLoader classLoader, Class<?> ... parameterTypes) {
        Class<?> clazz = ClassUtils.getClass(className, classLoader);
        if (clazz == null) {
            return null;
        }
        return ReflectionUtils.getConstructor(clazz, parameterTypes);
    }

    public static Members<Constructor<?>> getConstructors(Class<?> sourceClass) {
        return new Members(sourceClass, c -> {
            if (c == Object.class) {
                return null;
            }
            Constructor<?>[] constructors = c.getConstructors();
            List<Object> list = constructors == null ? Collections.emptyList() : Arrays.asList(constructors);
            return list.stream();
        });
    }

    @Nullable
    public static <T> Constructor<T> getDeclaredConstructor(Class<T> type) {
        Assert.requiredArgument(type != null, "type");
        Constructor<Object> constructor = CONSTRUCTOR_MAP.get(type);
        if (constructor == null) {
            try {
                constructor = type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            if (constructor == null) {
                return null;
            }
            ReflectionUtils.makeAccessible(constructor);
            Constructor<?> old = CONSTRUCTOR_MAP.putIfAbsent(type, constructor);
            if (old == null) {
                CONSTRUCTOR_MAP.purgeUnreferencedEntries();
            } else {
                constructor = old;
            }
        }
        return constructor;
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> type, Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return ReflectionUtils.getDeclaredConstructor(type);
        }
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return ((Members)ReflectionUtils.getDeclaredConstructors(type).all()).stream().filter(e -> ClassUtils.isAssignable(e.getParameterTypes(), parameterTypes)).findFirst().orElse(null);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(String className, @Nullable ClassLoader classLoader, Class<?> ... parameterTypes) {
        Class<?> clazz = ClassUtils.getClass(className, classLoader);
        if (clazz == null) {
            return null;
        }
        return ReflectionUtils.getDeclaredConstructor(clazz, parameterTypes);
    }

    public static Members<Constructor<?>> getDeclaredConstructors(Class<?> sourceClass) {
        return new Members(sourceClass, c -> {
            if (c == Object.class) {
                return null;
            }
            Constructor<?>[] constructors = c.getDeclaredConstructors();
            List<Object> list = constructors == null ? Collections.emptyList() : Arrays.asList(constructors);
            return list.stream();
        });
    }

    @Nullable
    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    public static Members<Field> getDeclaredFields(Class<?> sourceClass) {
        return new Members<Field>(sourceClass, c -> {
            if (c == Object.class) {
                return null;
            }
            Field[] fields = c.getDeclaredFields();
            List<Object> list = fields == null ? Collections.emptyList() : Arrays.asList(fields);
            return list.stream();
        });
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return ((Members)ReflectionUtils.getDeclaredMethods(clazz).all()).stream().filter(e -> e.getName().equals(name) && ClassUtils.isAssignable(e.getParameterTypes(), parameterTypes)).findFirst().orElse(null);
        }
    }

    public static Method getDeclaredMethod(String className, @Nullable ClassLoader classLoader, String methodName, Class<?> ... parameterTypes) {
        Class<?> clz = ClassUtils.getClass(className, classLoader);
        if (clz == null) {
            return null;
        }
        return ReflectionUtils.getDeclaredMethod(clz, methodName, parameterTypes);
    }

    public static Members<Method> getDeclaredMethods(Class<?> sourceClass) {
        return new Members<Method>(sourceClass, c -> {
            Method[] methods = c.getDeclaredMethods();
            List<Object> list = methods == null ? Collections.emptyList() : Arrays.asList(methods);
            return list.stream();
        });
    }

    public static <M extends Member> Members<M> getEntityMembers(Class<?> entityClass, Function<Class<?>, ? extends M[]> processor) {
        return new Members(entityClass, c -> Arrays.asList((Object[])processor.apply((Class<?>)c)).stream().filter(ENTITY_MEMBER));
    }

    private static <T extends Executable> ExecutableMatchingResults<T> getExecutableMatchingResults(T executable, Object[] params, int minStart) {
        Class<?>[] parameterTypes = executable.getParameterTypes();
        if (parameterTypes.length == 0) {
            return new ExecutableMatchingResults<T>(executable, new Object[0], 0);
        }
        Object[] cloneParams = (Object[])params.clone();
        Object[] args = new Object[parameterTypes.length];
        int count = 0;
        block0: for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            for (int a = Math.min(minStart, i); a < cloneParams.length; ++a) {
                Object value = cloneParams[a];
                if (value == null || !ClassUtils.isAssignableValue(parameterType, value)) continue;
                args[i] = value;
                cloneParams[a] = null;
                ++count;
                continue block0;
            }
        }
        return new ExecutableMatchingResults<T>(executable, args, count);
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    public static Members<Field> getFields(Class<?> sourceClass) {
        return new Members<Field>(sourceClass, c -> {
            if (c == Object.class) {
                return null;
            }
            Field[] fields = c.getFields();
            List<Object> list = fields == null ? Collections.emptyList() : Arrays.asList(fields);
            return list.stream();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (logger != null) return logger;
        Class<ReflectionUtils> clazz = ReflectionUtils.class;
        synchronized (ReflectionUtils.class) {
            if (logger != null) return logger;
            logger = LoggerFactory.getLogger(ReflectionUtils.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return ((Members)ReflectionUtils.getMethods(clazz).all()).stream().filter(e -> e.getName().equals(name) && ClassUtils.isAssignable(e.getParameterTypes(), parameterTypes)).findFirst().orElse(null);
        }
    }

    public static Method getMethod(String className, @Nullable ClassLoader classLoader, String methodName, Class<?> ... parameterTypes) {
        Class<?> clz = ClassUtils.getClass(className, classLoader);
        if (clz == null) {
            return null;
        }
        return ReflectionUtils.getMethod(clz, methodName, parameterTypes);
    }

    public static Members<Method> getMethods(Class<?> sourceClass) {
        return new Members<Method>(sourceClass, c -> {
            Method[] methods = c.getMethods();
            List<Object> list = methods == null ? Collections.emptyList() : Arrays.asList(methods);
            return list.stream();
        });
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && ReflectionUtils.isOverridable(method, targetClass) && targetClass != null && !targetClass.equals(method.getDeclaringClass())) {
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    try {
                        return targetClass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        return method;
                    }
                }
                Method specificMethod = ReflectionUtils.findMethod(targetClass, method.getName(), method.getParameterTypes());
                return specificMethod != null ? specificMethod : method;
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return method;
    }

    public static ExecutableMatchingResults<Method> getOverloadMethod(Class<?> sourceClass, String methodName, boolean strict, Predicate<Method> predicate, Object ... args) throws NoSuchMethodException {
        Assert.requiredArgument(sourceClass != null, "sourceClass");
        Stream<Method> methods = ((Members)ReflectionUtils.getMethods(sourceClass).withAll().all()).stream().filter(m -> StringUtils.isEmpty(methodName) || methodName.equals(m.getName())).filter(predicate);
        return ReflectionUtils.getByParams(methods, strict, args);
    }

    public static String getQualifiedMethodName(Method method) {
        return ReflectionUtils.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, @Nullable Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        return (clazz != null ? clazz : method.getDeclaringClass()).getName() + '.' + method.getName();
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleThrowable(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Exception) {
            ReflectionUtils.handleReflectionException((Exception)ex);
            throw Assert.shouldNeverGetHere();
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static <T> int hashCode(Class<? extends T> entityClass, T entity) {
        return ReflectionUtils.hashCode(entityClass, entity, true);
    }

    public static <T> int hashCode(Class<? extends T> entityClass, T entity, boolean deep) {
        Assert.requiredArgument(entityClass != null, "entityClass");
        if (entity == null) {
            return 0;
        }
        return ReflectionUtils.hashCode(ReflectionUtils.getDeclaredFields(entityClass).withSuperclass(), entity, deep);
    }

    public static int hashCode(Members<Field> members, Object entity) {
        return ReflectionUtils.hashCode(members, entity, true);
    }

    public static int hashCode(Members<Field> members, Object entity, boolean deep) {
        Assert.requiredArgument(members != null, "members");
        if (entity == null) {
            return 0;
        }
        int hashCode = 1;
        Iterator iterator = ((Members)members.all()).stream().filter(ENTITY_MEMBER).iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            hashCode = 31 * hashCode + ObjectUtils.hashCode(ReflectionUtils.get(field, entity), deep);
        }
        return hashCode;
    }

    public static int hashCode(Object entity) {
        return ReflectionUtils.hashCode(entity, true);
    }

    public static int hashCode(Object entity, boolean deep) {
        if (entity == null) {
            return 0;
        }
        return ReflectionUtils.hashCode(entity.getClass(), entity, deep);
    }

    public static Object invoke(Method method, @Nullable Object target, Object ... args) {
        ReflectionUtils.makeAccessible(method);
        try {
            return method.invoke(target, args == null ? new Object[]{} : args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> T invokeCloneMethod(Object source) {
        if (source == null) {
            return null;
        }
        if (!(source instanceof Cloneable)) {
            return null;
        }
        Method method = ReflectionUtils.getCloneMethod((Cloneable)source);
        if (method == null) {
            return null;
        }
        return (T)ReflectionUtils.invoke(method, source, new Object[0]);
    }

    public static <T> T invokeOverloadConstructor(Class<? extends T> sourceClass, boolean strict, Object ... args) throws NoSuchMethodException {
        Assert.requiredArgument(sourceClass != null, "sourceClass");
        Stream constructors = ((Members)ReflectionUtils.getConstructors(sourceClass).all()).stream();
        ExecutableMatchingResults results = ReflectionUtils.getByParams(constructors, strict, args);
        return ReflectionUtils.newInstance((Constructor)results.getExecutable(), results.getUnsafeParams());
    }

    public static <T> T invokeOverloadMethod(Class<?> sourceClass, String methodName, boolean strict, Object ... args) throws NoSuchMethodException {
        ExecutableMatchingResults<Method> results = ReflectionUtils.getOverloadMethod(sourceClass, methodName, strict, m -> Modifier.isStatic(m.getModifiers()), args);
        return (T)ReflectionUtils.invoke(results.getExecutable(), null, results.getUnsafeParams());
    }

    public static <T> T invokeOverloadMethod(Object target, String methodName, boolean strict, Object ... args) throws NoSuchMethodException {
        Assert.requiredArgument(target != null, "target");
        ExecutableMatchingResults<Method> results = ReflectionUtils.getOverloadMethod(target.getClass(), methodName, strict, m -> !Modifier.isStatic(m.getModifiers()), args);
        return (T)ReflectionUtils.invoke(results.getExecutable(), target, results.getUnsafeParams());
    }

    public static boolean isAvailable(Class<?> clazz) {
        return ReflectionUtils.isAvailable(clazz, () -> ReflectionUtils.getLogger());
    }

    public static <E extends Throwable> boolean isAvailable(Class<?> clazz, @Nullable Source<? extends Logger, ? extends E> loggerSource) throws E {
        return ReflectionUtils.isAvailable(clazz, loggerSource == null ? null : e -> {
            Logger logger = (Logger)loggerSource.get();
            if (logger == null) {
                logger = ReflectionUtils.getLogger();
            }
            ReflectionUtils.isAvailableLogger(clazz, logger, e);
        });
    }

    public static <E extends Throwable> boolean isAvailable(Class<?> clazz, @Nullable ConsumeProcessor<Throwable, E> accept) throws E {
        try {
            for (Method method : CLASS_PRESENT_METHODS) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable e) {
            if (accept != null) {
                accept.process(e);
            }
            return false;
        }
        return true;
    }

    public static boolean isAvailable(Class<?> clazz, @Nullable Logger logger) {
        return ReflectionUtils.isAvailable(clazz, logger == null ? null : e -> ReflectionUtils.isAvailableLogger(clazz, logger, e));
    }

    private static void isAvailableLogger(Class<?> clazz, Logger logger, Throwable e) {
        if (logger.isTraceEnabled()) {
            logger.trace(e, "This class[{}] cannot be included because:", clazz.getName());
        } else if (logger.isDebugEnabled()) {
            logger.debug("This class[{}] cannot be included because {}: {}", clazz.getName(), NestedExceptionUtils.getRootCause(e).getClass(), NestedExceptionUtils.getNonEmptyMessage(e, false));
        }
    }

    public static boolean isCloneable(Object source) {
        return source != null && source instanceof Cloneable && ReflectionUtils.getCloneMethod((Cloneable)source) != null;
    }

    public static boolean isDefault(Method method) {
        return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isInstance(Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
            return false;
        }
        return ReflectionUtils.getDeclaredConstructor(clazz) != null;
    }

    public static boolean isObjectMethod(Method method) {
        return ReflectionUtils.getDeclaredMethod(Object.class, method.getName(), method.getParameterTypes()) != null;
    }

    private static boolean isOverridable(Method method, Class targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return ClassUtils.getPackageName(method.getDeclaringClass()).equals(ClassUtils.getPackageName(targetClass));
    }

    public static boolean isSerialVersionUIDField(Field field) {
        return Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getName().equals(SERIAL_VERSION_UID_FIELD_NAME);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (ctor == null) {
            return;
        }
        if (!Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
            ctor.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (field == null) {
            return;
        }
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers()) || Modifier.isFinal(field.getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (method == null) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static <T extends Executable> Stream<ExecutableMatchingResults<T>> matchParams(Stream<T> sourceStream, boolean strict, Object ... params) {
        Stream<ExecutableMatchingResults<T>> stream;
        if (strict) {
            long validParametersCount = Arrays.asList(params).stream().filter(e -> e != null).count();
            stream = ReflectionUtils.matchParams(sourceStream, (int)validParametersCount, params).filter(e -> (long)e.getMatchingResultes() == validParametersCount);
        } else {
            stream = ReflectionUtils.matchParams(sourceStream, params.length, params);
        }
        return stream;
    }

    public static <T extends Executable> Stream<ExecutableMatchingResults<T>> matchParams(Stream<T> sourceStream, int validParametersCount, Object ... params) {
        Assert.requiredArgument(sourceStream != null, "sourceStream");
        Assert.requiredArgument(params != null, "params");
        return sourceStream.filter(e -> e.getParameterCount() <= validParametersCount).sorted(MEMBER_SCOPE_COMPARATOR).sorted((e1, e2) -> {
            Class<?>[] parameterTypes2;
            Class<?>[] parameterTypes1 = e1.getParameterTypes();
            int v = Integer.compare(parameterTypes1.length, (parameterTypes2 = e2.getParameterTypes()).length);
            if (v == 0) {
                int leftCount = 0;
                int rightCount = 0;
                for (int i = 0; i < parameterTypes1.length; ++i) {
                    if (ClassUtils.isAssignable(parameterTypes1[i], parameterTypes2[i])) {
                        ++leftCount;
                    }
                    if (!ClassUtils.isAssignable(parameterTypes2[i], parameterTypes1[i])) continue;
                    ++rightCount;
                }
                if (leftCount == rightCount) {
                    ExecutableMatchingResults<Executable> matchingResults1 = ReflectionUtils.getExecutableMatchingResults(e1, params, params.length);
                    ExecutableMatchingResults<Executable> matchingResults2 = ReflectionUtils.getExecutableMatchingResults(e2, params, params.length);
                    return matchingResults1.compareTo(matchingResults2);
                }
                return leftCount - rightCount;
            }
            return -v;
        }).map(e -> ReflectionUtils.getExecutableMatchingResults(e, params, 0)).sorted();
    }

    public static <T> T newInstance(Class<T> clazz) throws UnsupportedException {
        Constructor<T> constructor = ReflectionUtils.getDeclaredConstructor(clazz);
        if (constructor == null) {
            throw new UnsupportedException(clazz.getName());
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException(e);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        ReflectionUtils.makeAccessible(constructor);
        try {
            return constructor.newInstance(args == null ? new Object[]{} : args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newInstanceWithNullValues(Class<T> entityClass) throws UnsupportedException {
        Assert.requiredArgument(entityClass != null, "entityClass");
        try (Stream<Constructor> stream = ((Members)ReflectionUtils.getDeclaredConstructors(entityClass).all()).stream().sorted(MEMBER_SCOPE_COMPARATOR).sorted(Comparator.comparingInt(Constructor::getParameterCount));){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                Constructor constructor = (Constructor)iterator.next();
                T t = ReflectionUtils.newInstance(constructor, new Object[constructor.getParameterCount()]);
                return t;
            }
        }
        throw new UnsupportedException(entityClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newInstanceWithParams(Class<T> entityClass, Object ... params) throws UnsupportedException {
        Assert.requiredArgument(entityClass != null, "entityClass");
        Assert.requiredArgument(params != null, "params");
        try (Stream stream = ReflectionUtils.matchParams(((Members)ReflectionUtils.getDeclaredConstructors(entityClass).all()).stream(), false, params);){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                T t;
                ExecutableMatchingResults results = (ExecutableMatchingResults)iterator.next();
                try {
                    t = ReflectionUtils.newInstance((Constructor)results.getExecutable(), results.getParams());
                }
                catch (Exception exception) {}
                return t;
            }
        }
        throw new UnsupportedException(entityClass.getName());
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void set(Field field, Object target, Object value) {
        ReflectionUtils.makeAccessible(field);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static <T> String toString(Class<? extends T> entityClass, T entity) {
        return ReflectionUtils.toString(entityClass, entity, true);
    }

    public static <T> String toString(Class<? extends T> entityClass, T entity, boolean deep) {
        Assert.requiredArgument(entityClass != null, "entityClass");
        StringBuilder sb = new StringBuilder();
        ReflectionUtils.toString(sb, entityClass, entity, deep);
        return sb.toString();
    }

    public static <T> String toString(Members<Field> members, T entity, boolean deep) {
        Assert.requiredArgument(members != null, "members");
        if (entity == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(members.getSourceClass().getSimpleName());
        builder.append('(');
        Iterator iterator = ((Members)members.all()).stream().filter(ENTITY_MEMBER).iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            builder.append(field.getName());
            builder.append('=');
            Object value = ReflectionUtils.get(field, entity);
            if (value == entity) {
                builder.append("(this)");
            } else {
                builder.append(ObjectUtils.toString(value, deep));
            }
            if (!iterator.hasNext()) continue;
            builder.append(',').append(' ');
        }
        builder.append(')');
        return builder.toString();
    }

    public static String toString(Object entity) {
        return ReflectionUtils.toString(entity, true);
    }

    public static String toString(Object entity, boolean deep) {
        if (entity == null) {
            return null;
        }
        return ReflectionUtils.toString(entity.getClass(), entity, deep);
    }

    private static <T> void toString(StringBuilder sb, Class<? extends T> entityClass, T entity, boolean deep) {
        if (entity == null) {
            return;
        }
        sb.append(entityClass.getSimpleName());
        sb.append('(');
        Iterator iterator = ReflectionUtils.getDeclaredFields(entityClass).stream().filter(ENTITY_MEMBER).iterator();
        Class<? extends T> superclass = entityClass.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            sb.append("super=");
            ReflectionUtils.toString(sb, superclass, entity, deep);
            if (iterator.hasNext()) {
                sb.append(',').append(' ');
            }
        }
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            sb.append(field.getName());
            sb.append('=');
            Object value = ReflectionUtils.get(field, entity);
            if (value == entity) {
                sb.append("(this)");
            } else {
                sb.append(ObjectUtils.toString(value, deep));
            }
            if (!iterator.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append(')');
    }

    public static <T extends Enum<T>> T[] values(Class<?> enumClass) {
        Method method;
        Assert.requiredArgument(enumClass != null, "enumClass");
        Assert.isTrue(enumClass.isEnum(), enumClass + " not is enum");
        try {
            method = enumClass.getMethod("values", new Class[0]);
        }
        catch (Exception e) {
            return (Enum[])Array.newInstance(enumClass, 0);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            return (Enum[])Array.newInstance(enumClass, 0);
        }
        return (Enum[])ReflectionUtils.invoke(method, null, new Object[0]);
    }

    static {
        MEMBER_SCOPE_COMPARATOR = new MemberScopeComparator<Member>();
        try {
            OBJECT_CONSTRUCTOR = Object.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedException(ReflectionUtils.class.getName(), e);
        }
    }
}

