/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.reflect;

import io.basc.framework.core.reflect.FieldHolder;
import io.basc.framework.core.reflect.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Field;

public final class SerializableField
implements FieldHolder,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile transient Field field;
    private final String fieldName;
    private final Class<?> declaringClass;

    public SerializableField(Field field) {
        this.field = field;
        this.declaringClass = field == null ? null : field.getDeclaringClass();
        this.fieldName = field == null ? null : field.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Field getField() {
        if (this.field == null) {
            SerializableField serializableField = this;
            synchronized (serializableField) {
                if (this.field == null) {
                    this.field = ReflectionUtils.getDeclaredField(this.declaringClass, this.fieldName);
                }
            }
        }
        return this.field;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.getField().toString();
    }
}

