/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.reflect;

import io.basc.framework.core.reflect.MethodHolder;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;

public class SerializableMethod
implements MethodHolder,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile transient Method method;
    private final Class<?> declaringClass;
    private final String name;
    private final Class<?>[] parameterTypes;

    public SerializableMethod(Method method) {
        Assert.requiredArgument(method != null, "method");
        this.declaringClass = method.getDeclaringClass();
        this.method = method;
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method getMethod() {
        if (this.method == null) {
            SerializableMethod serializableMethod = this;
            synchronized (serializableMethod) {
                if (this.method == null) {
                    this.method = ReflectionUtils.getDeclaredMethod(this.declaringClass, this.name, this.parameterTypes);
                }
            }
        }
        return this.method;
    }

    public Class<?> getSourceClass() {
        return this.declaringClass;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public String toString() {
        return this.getMethod().toString();
    }
}

